/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import org.jetbrains.annotations.Nullable;

public class ForceParticles
extends TextureSheetParticle {
    private BlockPos tarPos = null;

    protected ForceParticles(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 80;
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.setSpriteFromAge(spriteSet);
        this.hasPhysics = false;
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        for (int lx = -5; lx <= 5; ++lx) {
            block1: for (int ly = -3; ly <= 3; ++ly) {
                for (int lz = -5; lz <= 5; ++lz) {
                    BlockPos checkTarPos = pos.offset(lx, ly, lz);
                    BlockState checkBlock = level.getBlockState(checkTarPos);
                    if (!checkBlock.is(AbyssTechBlocks.DISPLACED_VOID)) continue;
                    this.tarPos = checkTarPos;
                    continue block1;
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.tarPos != null) {
            double d = (double)this.tarPos.getX() + 0.4 > this.x ? this.x + 0.1 : (this.x = (double)this.tarPos.getX() + 0.6 < this.x ? this.x - 0.1 : this.x);
            double d2 = (double)this.tarPos.getY() + 0.4 > this.y ? this.y + 0.1 : (this.y = (double)this.tarPos.getY() + 0.6 < this.y ? this.y - 0.1 : this.y);
            this.z = (double)this.tarPos.getZ() + 0.4 > this.z ? this.z + 0.1 : ((double)this.tarPos.getZ() + 0.6 < this.z ? this.z - 0.1 : this.z);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ForceParticles(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

