/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class SoundWaveParticles
extends TextureSheetParticle {
    private float pSize = 1.0f;
    private float rotX = 1.55f;
    private float rotY = 0.0f;
    private float rotZ = 0.0f;

    protected SoundWaveParticles(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 1.05f;
        this.lifetime = 60;
        this.yd = 0.2f;
        this.xd = 0.0;
        this.zd = 0.0;
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        ++this.age;
        this.pSize += 0.008f;
        this.scale(this.pSize);
        super.tick();
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotationYXZ(this.rotY, this.rotX, this.rotZ);
        this.renderRotatedQuad(buffer, renderInfo, quaternion, partialTicks);
        quaternion.rotateY((float)Math.PI);
        this.renderRotatedQuad(buffer, renderInfo, quaternion, partialTicks);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new SoundWaveParticles(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

