/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import net.quasar.abysstech.screen.custom.GuideBookMenu;
import net.quasar.abysstech.screen.custom.GuideBookPageAsset;
import net.quasar.abysstech.screen.custom.GuideBookPages;

public class GuideBookScreen
extends AbstractContainerScreen<GuideBookMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/guide_book/guide_book_screen.png");
    private int pageNum = 0;
    private final List<GuideBookPageAsset> pages = GuideBookPages.getAllPages();
    private final int[] chapters = this.getChapters();
    private final int pageNumMax = this.pages.size() - 1;
    private final int pageNumMin = 0;
    private ImageButton rightArrow;
    private ImageButton leftArrow;
    private ImageButton jumpLast;
    private ImageButton jumpFirst;
    private ImageButton jumpChapterOne;
    private ImageButton jumpChapterTwo;
    private ImageButton jumpChapterThree;
    private ImageButton jumpChapterFour;
    private ImageButton jumpChapterFive;
    private ImageButton jumpChapterSix;
    private ImageButton craftTip;
    private boolean tipActive = false;
    private Item recOne = null;
    private Item recTwo = null;
    private Item[] recOneIng = null;
    private Item[] recTwoIng = null;
    private int baubleXV = 1;
    private int baubleYV = 1;
    private final int gl = this.width / 2;
    private final int gr = this.height / 2;
    private int baubleX = this.gl + this.width / 2;
    private int baubleY = this.gr + this.height / 2;

    public GuideBookScreen(GuideBookMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void onClose() {
        super.onClose();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PUT, (float)1.0f));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, "" + this.pageNum, this.imageWidth - 22, 10, 0x404040, false);
        this.drawPageText(guiGraphics, this.pageNum);
        super.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        int guiLeft = (this.width - this.imageWidth) / 2;
        int guiTop = (this.height - this.imageHeight) / 2;
        this.rightArrow = this.createImageButton(guiLeft + this.imageWidth - 38, guiTop + this.imageHeight - 15, 20, 10, "abysstech:textures/gui/guide_book/right_arrow.png", "abysstech:textures/gui/guide_book/right_arrow_hover.png", 2);
        this.leftArrow = this.createImageButton(guiLeft + 18, guiTop + this.imageHeight - 15, 20, 10, "abysstech:textures/gui/guide_book/left_arrow.png", "abysstech:textures/gui/guide_book/left_arrow_hover.png", 1);
        this.jumpLast = this.createImageButtonSetPage(guiLeft + this.imageWidth - 15, guiTop + this.imageHeight - 15, 10, 10, "abysstech:textures/gui/guide_book/jump_last.png", "abysstech:textures/gui/guide_book/jump_last_hover.png", this.pageNumMax);
        this.jumpFirst = this.createImageButtonSetPage(guiLeft + 5, guiTop + this.imageHeight - 15, 10, 10, "abysstech:textures/gui/guide_book/jump_first.png", "abysstech:textures/gui/guide_book/jump_first_hover.png", 0);
        this.jumpChapterOne = this.createImageButtonSetPage(guiLeft + 5, guiTop + 17, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[0]);
        this.jumpChapterTwo = this.createImageButtonSetPage(guiLeft + 5, guiTop + 32, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[1]);
        this.jumpChapterThree = this.createImageButtonSetPage(guiLeft + 5, guiTop + 47, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[2]);
        this.jumpChapterFour = this.createImageButtonSetPage(guiLeft + 5, guiTop + 62, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[3]);
        this.jumpChapterFive = this.createImageButtonSetPage(guiLeft + 5, guiTop + 77, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[4]);
        this.jumpChapterSix = this.createImageButtonSetPage(guiLeft + 5, guiTop + 92, 10, 10, "abysstech:textures/gui/guide_book/jump_chapter.png", "abysstech:textures/gui/guide_book/jump_chapter_hover.png", this.chapters[5]);
        this.craftTip = this.createImageButtonCraftHelp(guiLeft + this.imageWidth - 1, guiTop + 9, 20, 10, "abysstech:textures/gui/guide_book/craft_tip.png", "abysstech:textures/gui/guide_book/craft_tip_hover.png");
        this.updateWidgets();
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderCraftTips(guiGraphics);
        this.renderCraftTipBd(guiGraphics);
        this.renderCraftTipText(guiGraphics, mouseX, mouseY);
    }

    private void wierdBauble(GuiGraphics guiGraphics, int mx, int my) {
        if (this.baubleXV != 0) {
            this.baubleX += this.baubleXV;
        }
        if (this.baubleYV != 0) {
            this.baubleY += this.baubleYV;
        }
        if (this.baubleX < this.gl) {
            this.baubleX = this.gl + 1;
            if (this.baubleXV != 0) {
                this.baubleXV *= -1;
            }
        } else if (this.baubleX > this.gl + this.width) {
            this.baubleX = this.gl + this.width - 1;
            if (this.baubleXV != 0) {
                this.baubleXV *= -1;
            }
        }
        if (this.baubleY < this.gr) {
            this.baubleY = this.gr + 1;
            if (this.baubleYV != 0) {
                this.baubleYV *= -1;
            }
        } else if (this.baubleY > this.gr + this.height) {
            this.baubleY = this.gr + this.height - 1;
            if (this.baubleYV != 0) {
                this.baubleYV *= -1;
            }
        }
        if (this.baubleX < mx) {
            this.baubleXV = Math.min(this.baubleXV + 1, 10);
        } else if (this.baubleX > mx) {
            this.baubleXV = Math.max(this.baubleXV - 1, -10);
        }
        if (this.baubleY < my) {
            this.baubleYV = Math.min(this.baubleYV + 1, 10);
        } else if (this.baubleY > my) {
            this.baubleYV = Math.max(this.baubleYV - 1, -10);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 700.0f);
        guiGraphics.renderFakeItem(Items.DIAMOND.getDefaultInstance(), this.baubleX, this.baubleY, 0);
        poseStack.popPose();
    }

    private void renderCraftTips(GuiGraphics guiGraphics) {
        if (this.tipActive) {
            int guiLeft = (this.width - this.imageWidth) / 2;
            int guiTop = (this.height - this.imageHeight) / 2;
            if (this.recOne != null && this.recOneIng != null) {
                this.renderSingleGrid(guiGraphics, this.recOneIng, guiLeft + 188, guiTop + 25);
                this.renderSingleItem(guiGraphics, this.recOne, guiLeft + 250, guiTop + 45);
            }
            if (this.recTwo != null && this.recTwoIng != null) {
                this.renderSingleGrid(guiGraphics, this.recTwoIng, guiLeft + 188, guiTop + 95);
                this.renderSingleItem(guiGraphics, this.recTwo, guiLeft + 250, guiTop + 115);
            }
        }
    }

    private void renderSingleGrid(GuiGraphics guiGraphics, Item[] recipe, int guiLeft, int guiTop) {
        int xTranslation = 0;
        int yTranslation = 0;
        for (int i = 0; i < recipe.length; ++i) {
            if (recipe[i] != null) {
                this.renderSingleItem(guiGraphics, recipe[i], guiLeft + xTranslation, guiTop + yTranslation);
            }
            if ((xTranslation += 20) < 60) continue;
            xTranslation = 0;
            yTranslation += 20;
        }
    }

    private void renderSingleItem(GuiGraphics guiGraphics, Item item, int left, int top) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 700.0f);
        guiGraphics.renderFakeItem(item.getDefaultInstance(), left, top, 0);
        poseStack.popPose();
    }

    private void renderCraftTipBd(GuiGraphics guiGraphics) {
        if (this.tipActive) {
            int guiLeft = (this.width - this.imageWidth) / 2;
            int guiTop = (this.height - this.imageHeight) / 2;
            this.renderImageFromTexture(guiGraphics, "abysstech:textures/gui/guide_book/craft_tip_backdrop.png", guiLeft + this.imageWidth - 1, guiTop + 19, 0, 0, 105, 140, 105, 140, 100);
            if (this.recOne != null) {
                this.renderImageFromTexture(guiGraphics, "abysstech:textures/gui/guide_book/craft_tip_grid.png", guiLeft + this.imageWidth - 1, guiTop + 19, 0, 0, 105, 70, 105, 70, 150);
            }
            if (this.recTwo != null) {
                this.renderImageFromTexture(guiGraphics, "abysstech:textures/gui/guide_book/craft_tip_grid.png", guiLeft + this.imageWidth - 1, guiTop + 89, 0, 0, 105, 70, 105, 70, 150);
            }
        }
    }

    private void renderImageFromTexture(GuiGraphics guiGraphics, String texturePath, int left, int top, int xOff, int yOff, int width, int height, int aWidth, int aHeight, int z) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, (float)z);
        guiGraphics.blit(ResourceLocation.parse((String)texturePath), left, top, (float)xOff, (float)yOff, width, height, aWidth, aHeight);
        guiGraphics.pose().popPose();
    }

    private void renderCraftTipText(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.tipActive) {
            int guiLeft = (this.width - this.imageWidth) / 2;
            int guiTop = (this.height - this.imageHeight) / 2;
            if (this.recOne != null && this.recOneIng != null) {
                this.renderGridItemText(guiGraphics, this.recOneIng, this.recOne, guiLeft + 188, guiTop + 25, mouseX, mouseY);
            }
            if (this.recTwo != null && this.recTwoIng != null) {
                this.renderGridItemText(guiGraphics, this.recTwoIng, this.recTwo, guiLeft + 188, guiTop + 95, mouseX, mouseY);
            }
        }
    }

    private void renderSingleItemText(GuiGraphics guiGraphics, Component text, int mouseX, int mouseY) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        guiGraphics.drawString(this.font, text, mouseX, mouseY, 13058724, true);
        guiGraphics.pose().popPose();
    }

    private void renderGridItemText(GuiGraphics guiGraphics, Item[] recipe, Item recipeResult, int left, int top, int mouseX, int mouseY) {
        int xTranslation = 0;
        int yTranslation = 0;
        for (int i = 0; i < recipe.length; ++i) {
            if (recipe[i] != null && mouseX > left + xTranslation && mouseX < left + xTranslation + 20 && mouseY > top + yTranslation && mouseY < top + yTranslation + 20) {
                this.renderSingleItemText(guiGraphics, recipe[i].getDefaultInstance().getHoverName(), mouseX - 20, mouseY + 15);
            }
            if ((xTranslation += 20) < 60) continue;
            xTranslation = 0;
            yTranslation += 20;
        }
        if (mouseX > left + 60 && mouseX < left + 60 + 20 && mouseY > top + 20 && mouseY < top + 20 + 20) {
            this.renderSingleItemText(guiGraphics, recipeResult.getDefaultInstance().getHoverName(), mouseX - 20, mouseY + 15);
        }
    }

    private void drawPageText(GuiGraphics guiGraphics, int page) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.7f, 0.7f, 1.0f);
        int textY = 25;
        int textX = page == 0 ? 25 : 10;
        int textYSpacing = page == 0 ? 22 : 10;
        for (int i = 0; i < 2; ++i) {
            List<Component> pageText = this.getPageText(this.getPageAssets(), i == 1);
            for (Component textLine : pageText) {
                guiGraphics.drawString(this.font, textLine, textX, textY, 0, false);
                textY += textYSpacing;
            }
            textY = 25;
            textX = 135;
        }
        guiGraphics.pose().popPose();
    }

    private List<Component> getPageText(GuideBookPageAsset pageAsset, boolean right) {
        ArrayList<Component> basicText = new ArrayList<MutableComponent>();
        if (pageAsset.getChapter() == -1) {
            if (!right) {
                basicText.add((Component)Component.literal((String)"Getting started"));
                basicText.add((Component)Component.literal((String)"Divination"));
                basicText.add((Component)Component.literal((String)"Artifice"));
                basicText.add((Component)Component.literal((String)"Alchemy"));
                basicText.add((Component)Component.literal((String)"Conjuration"));
                basicText.add((Component)Component.literal((String)"Insight"));
            } else {
                basicText.add((Component)Component.literal((String)" "));
            }
        } else {
            basicText = AbyssTechRenderHelper.textSplitter(!right ? pageAsset.getLeftText() : pageAsset.getRightText(), 21);
        }
        return basicText;
    }

    private int[] getChapters() {
        int[] chapters = new int[]{0, 0, 0, 0, 0, 0};
        block0: for (int c = 0; c < chapters.length; ++c) {
            for (int p = 0; p < this.pages.size(); ++p) {
                if (this.pages.get(p).getChapter() != c + 1) continue;
                chapters[c] = p;
                continue block0;
            }
        }
        return chapters;
    }

    private GuideBookPageAsset getPageAssets() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pageNum != i) continue;
            return this.pages.get(i);
        }
        return this.pages.getFirst();
    }

    private Item[] getRecipeArray(Item itemResult) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            List recipes = level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
            for (RecipeHolder holder : recipes) {
                ItemStack output = ((CraftingRecipe)holder.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (!output.is(itemResult)) continue;
                Recipe recipe = holder.value();
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    int width = shapedRecipe.getWidth();
                    int height = shapedRecipe.getHeight();
                    NonNullList ingredients = shapedRecipe.getIngredients();
                    Item[] items = new Item[9];
                    for (int row = 0; row < height; ++row) {
                        for (int col = 0; col < width; ++col) {
                            ItemStack[] stacks;
                            int ingredientIndex = col + row * width;
                            if (ingredientIndex >= ingredients.size() || (stacks = ((Ingredient)ingredients.get(ingredientIndex)).getItems()).length <= 0) continue;
                            items[row * 3 + col] = stacks[0].getItem();
                        }
                    }
                    return items;
                }
                NonNullList ingredients = ((CraftingRecipe)holder.value()).getIngredients();
                Item[] items = new Item[ingredients.size()];
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack[] stacks = ((Ingredient)ingredients.get(i)).getItems();
                    if (stacks.length <= 0) continue;
                    items[i] = stacks[0].getItem();
                }
                return items;
            }
        }
        return null;
    }

    private void updateWidgets() {
        this.removeAllWidgets();
        this.tipActive = false;
        this.recOne = null;
        this.recTwo = null;
        this.recOneIng = null;
        this.recTwoIng = null;
        GuideBookPageAsset currentPage = this.getPageAssets();
        switch (currentPage.getChapter()) {
            case -1: {
                this.addRenderableWidget((GuiEventListener)this.jumpChapterOne);
                this.addRenderableWidget((GuiEventListener)this.jumpChapterTwo);
                this.addRenderableWidget((GuiEventListener)this.jumpChapterThree);
                this.addRenderableWidget((GuiEventListener)this.jumpChapterFour);
                this.addRenderableWidget((GuiEventListener)this.jumpChapterFive);
                this.addRenderableWidget((GuiEventListener)this.jumpChapterSix);
                this.addRenderableWidget((GuiEventListener)this.rightArrow);
                this.addRenderableWidget((GuiEventListener)this.jumpLast);
                break;
            }
            case -2: {
                this.addRenderableWidget((GuiEventListener)this.leftArrow);
                this.addRenderableWidget((GuiEventListener)this.jumpFirst);
                break;
            }
            default: {
                this.addRenderableWidget((GuiEventListener)this.leftArrow);
                this.addRenderableWidget((GuiEventListener)this.rightArrow);
                this.addRenderableWidget((GuiEventListener)this.jumpFirst);
                this.addRenderableWidget((GuiEventListener)this.jumpLast);
            }
        }
        if (currentPage.getRecOne() != null) {
            this.recOne = currentPage.getRecOne();
            this.recOneIng = this.getRecipeArray(this.recOne);
        }
        if (currentPage.getRecTwo() != null) {
            this.recTwo = currentPage.getRecTwo();
            this.recTwoIng = this.getRecipeArray(this.recTwo);
        }
        if (currentPage.hasCraftTip()) {
            this.addRenderableWidget((GuiEventListener)this.craftTip);
        }
    }

    private void removeAllWidgets() {
        ImageButton[] allButtons = new ImageButton[]{this.leftArrow, this.rightArrow, this.jumpLast, this.jumpFirst, this.jumpChapterOne, this.jumpChapterTwo, this.jumpChapterThree, this.jumpChapterFour, this.jumpChapterFive, this.jumpChapterSix, this.craftTip};
        for (int i = 0; i < allButtons.length; ++i) {
            this.removeWidget((GuiEventListener)allButtons[i]);
        }
    }

    private void setPage(int page) {
        this.pageNum = page;
        this.updateWidgets();
    }

    private void onPress(int type) {
        switch (type) {
            case 1: {
                this.turnPageLeft();
                break;
            }
            case 2: {
                this.turnPageRight();
                break;
            }
            default: {
                System.out.println("GUIDE BOOK BUTTON TYPE IS OUT OF BOUNDS");
            }
        }
    }

    private void turnPageRight() {
        ++this.pageNum;
        this.updateWidgets();
    }

    private void turnPageLeft() {
        --this.pageNum;
        this.updateWidgets();
    }

    private void toggleTip() {
        this.tipActive = !this.tipActive;
    }

    private ImageButton createImageButton(int left, int top, int width, int height, String texture, String textureHover, int type) {
        return new ImageButton(this, left, top, width, height, new WidgetSprites(ResourceLocation.parse((String)texture), ResourceLocation.parse((String)textureHover)), press -> this.onPress(type)){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }

            public void playDownSound(SoundManager handler) {
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            }
        };
    }

    private ImageButton createImageButtonSetPage(int left, int top, int width, int height, String texture, String textureHover, int page) {
        return new ImageButton(this, left, top, width, height, new WidgetSprites(ResourceLocation.parse((String)texture), ResourceLocation.parse((String)textureHover)), press -> this.setPage(page)){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }

            public void playDownSound(SoundManager handler) {
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            }
        };
    }

    private ImageButton createImageButtonCraftHelp(int left, int top, int width, int height, String texture, String textureHover) {
        return new ImageButton(this, left, top, width, height, new WidgetSprites(ResourceLocation.parse((String)texture), ResourceLocation.parse((String)textureHover)), press -> this.toggleTip()){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }

            public void playDownSound(SoundManager handler) {
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
            }
        };
    }
}

