/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class AbyssTechShapePlacerUtil {
    static Random random = new Random();

    public static void placeFilledCircleAxis(Level level, BlockPos pos, Block toPlace, @Nullable Block toReplace, boolean replaceAll, int radius, Direction.Axis axis) {
        for (int a = -radius; a < radius; ++a) {
            for (int b = -radius; b < radius; ++b) {
                BlockPos tPos;
                int dSq = a * a + b * b;
                int rSq = radius * radius;
                if (dSq > rSq) continue;
                switch (axis) {
                    case X: {
                        BlockPos blockPos = pos.offset(a, b, 0);
                        break;
                    }
                    case Y: {
                        BlockPos blockPos = pos.offset(a, 0, b);
                        break;
                    }
                    default: {
                        BlockPos blockPos = tPos = pos.offset(0, a, b);
                    }
                }
                if (replaceAll) {
                    level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                    continue;
                }
                if (toReplace != null) {
                    if (!level.getBlockState(tPos).is(toReplace)) continue;
                    level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                    continue;
                }
                if (!level.getBlockState(tPos).isAir()) continue;
                level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
            }
        }
    }

    public static void placeFilledCircleAxisMixed(Level level, BlockPos pos, Block toPlace, @Nullable Block altBlock, @Nullable Block toReplace, boolean replaceAll, int radius, Direction.Axis axis, float chanceForAlt) {
        for (int a = -radius; a < radius; ++a) {
            for (int b = -radius; b < radius; ++b) {
                BlockPos tPos;
                int dSq = a * a + b * b;
                int rSq = radius * radius;
                if (dSq > rSq) continue;
                switch (axis) {
                    case X: {
                        BlockPos blockPos = pos.offset(a, b, 0);
                        break;
                    }
                    case Y: {
                        BlockPos blockPos = pos.offset(a, 0, b);
                        break;
                    }
                    default: {
                        BlockPos blockPos = tPos = pos.offset(0, a, b);
                    }
                }
                if (replaceAll) {
                    level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
                    continue;
                }
                if (toReplace != null) {
                    if (!level.getBlockState(tPos).is(toReplace)) continue;
                    level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
                    continue;
                }
                if (!level.getBlockState(tPos).isAir()) continue;
                level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
            }
        }
    }

    private static Block getBlockFromChance(Block mainBlock, Block altBlock, float chance) {
        if (altBlock == null) {
            altBlock = Blocks.AIR;
        }
        return random.nextFloat() >= chance ? mainBlock : altBlock;
    }

    public static void placeFilledSphere(Level level, BlockPos pos, Block toPlace, @Nullable Block toReplace, boolean replaceAll, int radius) {
        for (int a = -radius; a < radius; ++a) {
            for (int b = -radius; b < radius; ++b) {
                for (int c = -radius; c < radius; ++c) {
                    int dSq = a * a + b * b + c * c;
                    int rSq = radius * radius;
                    if (dSq > rSq) continue;
                    BlockPos tPos = pos.offset(a, b, c);
                    if (replaceAll) {
                        level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                        continue;
                    }
                    if (toReplace != null) {
                        if (!level.getBlockState(tPos).is(toReplace)) continue;
                        level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                        continue;
                    }
                    if (!level.getBlockState(tPos).isAir()) continue;
                    level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                }
            }
        }
    }

    public static void placeFilledSphere(Level level, BlockPos pos, Block toPlace, @Nullable TagKey<Block> toReplaceKey, int radius, boolean replaceAll) {
        for (int a = -radius; a < radius; ++a) {
            for (int b = -radius; b < radius; ++b) {
                for (int c = -radius; c < radius; ++c) {
                    int dSq = a * a + b * b + c * c;
                    int rSq = radius * radius;
                    if (dSq > rSq) continue;
                    BlockPos tPos = pos.offset(a, b, c);
                    if (replaceAll) {
                        level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                        continue;
                    }
                    if (toReplaceKey != null) {
                        if (!level.getBlockState(tPos).is(toReplaceKey)) continue;
                        level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                        continue;
                    }
                    if (!level.getBlockState(tPos).isAir()) continue;
                    level.setBlockAndUpdate(tPos, toPlace.defaultBlockState());
                }
            }
        }
    }

    public static void placeFilledSphereMixed(Level level, BlockPos pos, Block toPlace, @Nullable Block altBlock, @Nullable TagKey<Block> toReplace, boolean replaceAll, int radius, float chanceForAlt) {
        for (int a = -radius; a < radius; ++a) {
            for (int b = -radius; b < radius; ++b) {
                for (int c = -radius; c < radius; ++c) {
                    int dSq = a * a + b * b + c * c;
                    int rSq = radius * radius;
                    if (dSq > rSq) continue;
                    BlockPos tPos = pos.offset(a, b, c);
                    if (replaceAll) {
                        level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
                        continue;
                    }
                    if (toReplace != null) {
                        if (!level.getBlockState(tPos).is(toReplace)) continue;
                        level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
                        continue;
                    }
                    if (!level.getBlockState(tPos).isAir()) continue;
                    level.setBlockAndUpdate(tPos, AbyssTechShapePlacerUtil.getBlockFromChance(toPlace, altBlock, chanceForAlt).defaultBlockState());
                }
            }
        }
    }
}

