/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.util;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechUtility;

public class AbyssTechToolUtility {
    private static Random random = new Random();

    public static void toolDropSpecialItem(Level level, BlockPos pos, TagKey<Block> tag, Item toDrop, int chanceOneIn) {
        if (level.getBlockState(pos).is(tag) && random.nextInt(chanceOneIn) < 1) {
            AbyssTechUtility.ItemSimpleSpawn(level, pos, toDrop);
        }
    }

    public static void toolDropBonusMined(Level level, BlockPos pos, TagKey<Block> tag, int chanceOneIn, int amountFloor, int amountCelling) {
        if (level.getBlockState(pos).is(tag) && random.nextInt(chanceOneIn) < 1) {
            Item bonusItem;
            ServerLevel serverLevel = ((ServerLevel)level).getLevel();
            LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(LootContextParams.TOOL, (Object)((Item)AbyssTechItems.BOUNDARY_PICKAXE.get()).getDefaultInstance());
            List drops = level.getBlockState(pos).getDrops(lootBuilder);
            Item item = bonusItem = drops.isEmpty() ? null : ((ItemStack)drops.getFirst()).getItem();
            if (bonusItem != null) {
                int numToDrop = random.nextInt(amountFloor, amountCelling);
                for (int i = 0; i < numToDrop; ++i) {
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, bonusItem);
                }
            }
        }
    }
}

