/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.util;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.TuningCrystal;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.block.entity.custom.PillarConductingBlockEntity;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssEssenceSource;
import net.quasar.abysstech.util.AbyssTechAttachmentType;

public class AbyssTechUtility {
    private static final Random random = new Random();
    private static final UUID DUMMY_UUID = UUID.fromString("a8a8a8a8-0000-0000-0000-000000000000");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(DUMMY_UUID, "abyssTechDummy");

    public static AbyssEssenceSource GatherEssence(Level level, BlockPos pos, AbyssEssenceSource essenceTarget, int searchRadius, int essenceCost) {
        boolean search = true;
        if (essenceTarget != null) {
            essenceTarget.setHasEssence(false);
            BlockEntity blockEntity = level.getBlockEntity((BlockPos)essenceTarget);
            if (blockEntity instanceof PillarConductingBlockEntity) {
                PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                if (pillarConductingBlock.getEssence() >= essenceCost) {
                    pillarConductingBlock.setEssence(pillarConductingBlock.getEssence() - essenceCost);
                    essenceTarget.setHasEssence(true);
                    search = false;
                }
            } else {
                blockEntity = level.getBlockEntity((BlockPos)essenceTarget);
                if (blockEntity instanceof EssenceJarBlockEntity) {
                    EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity;
                    if (essenceJarBlock.getEssence() >= essenceCost) {
                        essenceJarBlock.setEssence(essenceJarBlock.getEssence() - essenceCost);
                        essenceTarget.setHasEssence(true);
                        search = false;
                    }
                } else {
                    essenceTarget = null;
                }
            }
            if (essenceTarget != null && essenceTarget.hasEssence()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)essenceTarget.getX() + 0.5f), (double)((float)essenceTarget.getY() + 0.5f), (double)((float)essenceTarget.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
            }
        }
        if (search) {
            block0: for (int x = -searchRadius; x <= searchRadius; ++x) {
                for (int y = -searchRadius; y <= searchRadius; ++y) {
                    for (int z = -searchRadius; z <= searchRadius; ++z) {
                        BlockPos tarBlockPos = pos.offset(x, y, z);
                        AbyssEssenceSource newEssenceTarget = new AbyssEssenceSource(tarBlockPos.getX(), tarBlockPos.getY(), tarBlockPos.getZ(), false);
                        BlockEntity blockEntity = level.getBlockEntity((BlockPos)newEssenceTarget);
                        if (blockEntity instanceof PillarConductingBlockEntity) {
                            PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                            if (pillarConductingBlock.getEssence() >= essenceCost) {
                                pillarConductingBlock.setEssence(pillarConductingBlock.getEssence() - essenceCost);
                                newEssenceTarget.setHasEssence(true);
                                essenceTarget = newEssenceTarget;
                            }
                        } else {
                            EssenceJarBlockEntity essenceJarBlock;
                            blockEntity = level.getBlockEntity((BlockPos)newEssenceTarget);
                            if (blockEntity instanceof EssenceJarBlockEntity && (essenceJarBlock = (EssenceJarBlockEntity)blockEntity).getEssence() >= essenceCost) {
                                essenceJarBlock.setEssence(essenceJarBlock.getEssence() - essenceCost);
                                newEssenceTarget.setHasEssence(true);
                                essenceTarget = newEssenceTarget;
                            }
                        }
                        if (!newEssenceTarget.hasEssence()) continue;
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)tarBlockPos.getX() + 0.5f), (double)((float)tarBlockPos.getY() + 0.5f), (double)((float)tarBlockPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
                        break block0;
                    }
                }
            }
        }
        return essenceTarget;
    }

    public static AbyssEssenceSource GatherEssence(Level level, BlockPos pos, AbyssEssenceSource essenceTarget, int searchRadius, int essenceCost, int instabilityAmount) {
        if ((essenceTarget = AbyssTechUtility.GatherEssence(level, pos, essenceTarget, searchRadius, essenceCost)) != null && essenceTarget.hasEssence()) {
            AbyssTechUtility.setThresholdIntegrity(level, pos, instabilityAmount, true);
        }
        return essenceTarget;
    }

    public static boolean SearchAndTakeEssence(Level level, BlockPos pos, int searchRadius, int essenceCost) {
        boolean essenceFound = false;
        block0: for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos tarBlockPos = pos.offset(x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity(tarBlockPos);
                    if (blockEntity instanceof PillarConductingBlockEntity) {
                        PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                        if (pillarConductingBlock.getEssence() >= essenceCost) {
                            pillarConductingBlock.setEssence(pillarConductingBlock.getEssence() - essenceCost);
                            essenceFound = true;
                        }
                    } else {
                        EssenceJarBlockEntity essenceJarBlock;
                        blockEntity = level.getBlockEntity(tarBlockPos);
                        if (blockEntity instanceof EssenceJarBlockEntity && (essenceJarBlock = (EssenceJarBlockEntity)blockEntity).getEssence() >= essenceCost) {
                            essenceJarBlock.setEssence(essenceJarBlock.getEssence() - essenceCost);
                            essenceFound = true;
                        }
                    }
                    if (!essenceFound) continue;
                    ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)tarBlockPos.getX() + 0.5f), (double)((float)tarBlockPos.getY() + 0.5f), (double)((float)tarBlockPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                    level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
                    break block0;
                }
            }
        }
        return essenceFound;
    }

    public static boolean SearchAndTakeEssence(Level level, BlockPos pos, int searchRadius, int essenceCost, int instabilityAmount) {
        boolean essenceFound = AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, essenceCost);
        if (essenceFound) {
            AbyssTechUtility.setThresholdIntegrity(level, pos, instabilityAmount, true);
        }
        return essenceFound;
    }

    public static AbyssEssenceSource GatherEssenceFromPillar(Level level, BlockPos pos, AbyssEssenceSource essenceTarget, int searchRadius, int essenceCost) {
        boolean search = true;
        if (essenceTarget != null) {
            essenceTarget.setHasEssence(false);
            BlockEntity blockEntity = level.getBlockEntity((BlockPos)essenceTarget);
            if (blockEntity instanceof PillarConductingBlockEntity) {
                PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                int pillarEssence = pillarConductingBlock.getEssence();
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof EssenceJarBlockEntity) {
                    EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity2;
                    if (pillarEssence >= essenceCost && essenceJarBlock.getEssence() + essenceCost <= 500) {
                        pillarConductingBlock.setEssence(pillarEssence - essenceCost);
                        essenceJarBlock.setEssence(essenceJarBlock.getEssence() + essenceCost);
                        search = false;
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)essenceTarget.getX() + 0.5f), (double)((float)essenceTarget.getY() + 0.5f), (double)((float)essenceTarget.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
                    }
                }
            } else {
                essenceTarget = null;
            }
        }
        if (search) {
            block0: for (int x = -searchRadius; x <= searchRadius; ++x) {
                for (int y = -searchRadius; y <= searchRadius; ++y) {
                    for (int z = -searchRadius; z <= searchRadius; ++z) {
                        BlockPos tarBlockPos = pos.offset(x, y, z);
                        AbyssEssenceSource newEssenceTarget = new AbyssEssenceSource(tarBlockPos.getX(), tarBlockPos.getY(), tarBlockPos.getZ(), false);
                        BlockEntity blockEntity = level.getBlockEntity((BlockPos)newEssenceTarget);
                        if (!(blockEntity instanceof PillarConductingBlockEntity)) continue;
                        PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                        int pillarEssence = pillarConductingBlock.getEssence();
                        BlockEntity blockEntity3 = level.getBlockEntity(pos);
                        if (!(blockEntity3 instanceof EssenceJarBlockEntity)) continue;
                        EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity3;
                        if (pillarEssence < essenceCost || essenceJarBlock.getEssence() + essenceCost > 500) continue;
                        pillarConductingBlock.setEssence(pillarEssence - essenceCost);
                        essenceJarBlock.setEssence(essenceJarBlock.getEssence() + essenceCost);
                        newEssenceTarget.setHasEssence(true);
                        essenceTarget = newEssenceTarget;
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.ESSENCE_PARTICLES.get(), (double)((float)tarBlockPos.getX() + 0.5f), (double)((float)tarBlockPos.getY() + 0.5f), (double)((float)tarBlockPos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
                        break block0;
                    }
                }
            }
        }
        return essenceTarget;
    }

    public static void DrawPathToEssence(Level level, BlockPos pos, int searchRadius, BlockState centerType) {
        Block validConduct = (Block)AbyssTechBlocks.PILLAR_CONDUCTING.get();
        Block validJar = (Block)AbyssTechBlocks.ESSENCE_JAR.get();
        Block validCoalesce = (Block)AbyssTechBlocks.PILLAR_COALESCING.get();
        block0: for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    boolean sourceFound;
                    BlockPos tarBlockPos = pos.offset(x, y, z);
                    BlockState checkBlock = level.getBlockState(tarBlockPos);
                    boolean bl = centerType.is(AbyssTechBlocks.PILLAR_CONDUCTING) ? checkBlock.is(validCoalesce) : (centerType.is(AbyssTechBlocks.ESSENCE_JAR) ? checkBlock.is(validConduct) : (sourceFound = checkBlock.is(validConduct) || checkBlock.is(validJar)));
                    if (!sourceFound) continue;
                    AbyssTechUtility.drawPathToTarget(level, pos, tarBlockPos, 0.05f, AbyssTechParticles.ESSENCE_BEAM_PARTICLES.get());
                    level.playSound(null, pos, AbyssTechSounds.ESSENCE_RING.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(2.0f));
                    if (!centerType.is(AbyssTechBlocks.PILLAR_CONDUCTING)) break block0;
                }
            }
        }
    }

    public static void drawPathToTarget(Level level, BlockPos pos, BlockPos tarBlockPos, float particleSpacingStep, SimpleParticleType particleType) {
        for (float d = 0.0f; d < 1.0f; d += particleSpacingStep) {
            ((ServerLevel)level).sendParticles((ParticleOptions)particleType, (double)((float)pos.getX() + (float)(tarBlockPos.getX() - pos.getX()) * d + 0.5f), (double)((float)pos.getY() + (float)(tarBlockPos.getY() - pos.getY()) * d + 0.5f), (double)((float)pos.getZ() + (float)(tarBlockPos.getZ() - pos.getZ()) * d + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static BlockPos getOffsetPosFromFace(BlockPos pos, Direction p, int offset) {
        return switch (p) {
            case Direction.NORTH -> pos.north(offset);
            case Direction.EAST -> pos.east(offset);
            case Direction.SOUTH -> pos.south(offset);
            case Direction.WEST -> pos.west(offset);
            case Direction.DOWN -> pos.below(offset);
            default -> pos.above(offset);
        };
    }

    public static void setThresholdIntegrity(Level level, BlockPos pos, int amount, boolean adding) {
        LevelChunk chunk = level.getChunkAt(pos);
        int maxAmount = 11000;
        int minAmount = 0;
        if (adding) {
            chunk.setData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY, (Object)Math.min((Integer)chunk.getData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY) + amount, maxAmount));
        } else {
            chunk.setData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY, (Object)Math.max((Integer)chunk.getData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY) - amount, minAmount));
        }
    }

    public static void setThresholdIntegrity(Level level, BlockPos pos, int amount) {
        LevelChunk chunk = level.getChunkAt(pos);
        chunk.setData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY, (Object)amount);
    }

    public static int getThresholdIntegrity(Level level, BlockPos pos) {
        LevelChunk chunk = level.getChunkAt(pos);
        return (Integer)chunk.getData(AbyssTechAttachmentType.THRESHOLD_INSTABILITY);
    }

    public static void thrownPotionSimpleSpawn(Level level, BlockPos pos, boolean randomlyThrown, double amplifier) {
        ThrownPotion thrownPotion = (ThrownPotion)EntityType.POTION.create(level);
        List<Holder<Potion>> potionList = AbyssTechUtility.getRandomPotion();
        if (thrownPotion != null && !potionList.isEmpty()) {
            ItemStack potionItem = PotionContents.createItemStack((Item)Items.SPLASH_POTION, potionList.get(random.nextInt(potionList.size())));
            thrownPotion.setItem(potionItem);
            thrownPotion.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (randomlyThrown) {
                thrownPotion.setDeltaMovement(random.nextDouble(1.0) - 0.5, 0.5 + amplifier * 0.2, random.nextDouble(1.0) - 0.5);
            }
            level.addFreshEntity((Entity)thrownPotion);
        }
    }

    public static List<Holder<Potion>> getRandomPotion() {
        Registry potionRegistry = BuiltInRegistries.POTION;
        ArrayList<Holder<Potion>> potionList = new ArrayList<Holder<Potion>>();
        potionRegistry.holders().forEach(potionList::add);
        return potionList;
    }

    public static void MobSimpleSpawn(Level level, BlockPos pos, Entity entity) {
        if (level != null) {
            entity.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    public static void MobSpawnAggressiveTowards(Level level, BlockPos pos, PathfinderMob pathfinderMob, LivingEntity angryAt) {
        if (level != null) {
            pathfinderMob.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            pathfinderMob.setAggressive(true);
            pathfinderMob.setTarget(angryAt);
            level.addFreshEntity((Entity)pathfinderMob);
        }
    }

    public static void ItemSimpleSpawn(Level level, BlockPos pos, Item item) {
        ItemEntity spawnExtraItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)item));
        spawnExtraItem.setPickUpDelay(10);
        level.addFreshEntity((Entity)spawnExtraItem);
    }

    public static void ItemSimpleSpawn(Level level, BlockPos pos, Item item, int amount) {
        for (int i = 0; i < amount; ++i) {
            ItemEntity spawnExtraItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)item));
            spawnExtraItem.setPickUpDelay(10);
            level.addFreshEntity((Entity)spawnExtraItem);
        }
    }

    public static void ItemSimpleSpawn(Level level, BlockPos pos, Item item, double xOffset, double yOffset, double zOffset) {
        ItemEntity spawnExtraItem = new ItemEntity(level, (double)pos.getX() + xOffset + 0.5, (double)pos.getY() + yOffset + 0.5, (double)pos.getZ() + zOffset + 0.5, new ItemStack((ItemLike)item));
        spawnExtraItem.setPickUpDelay(10);
        level.addFreshEntity((Entity)spawnExtraItem);
    }

    public static int flowTuneDetect(Level level, BlockPos pos, int yOffset, boolean canUseUpgrade, int baseRate, int tunedRate, int upgradedRate) {
        BlockState state = level.getBlockState(pos.offset(0, yOffset, 0));
        return state.is(AbyssTechBlocks.TUNING_CRYSTAL_FLOW) ? (((Boolean)state.getValue((Property)TuningCrystal.upgraded)).booleanValue() && canUseUpgrade ? upgradedRate : tunedRate) : baseRate;
    }

    public static int tickRateThresholdDivider(Level level, BlockPos pos, int rate, int thresholdAmount, float percentOf, int rateFloor) {
        return AbyssTechUtility.getThresholdIntegrity(level, pos) >= thresholdAmount ? (int)Math.max((float)rateFloor, (float)rate * percentOf) : rate;
    }

    public static int embraceTuneDetect(Level level, BlockPos pos, int yOffset, boolean canUseUpgrade, int baseRadius, int tunedRadius, int upgradedRadius) {
        BlockState state = level.getBlockState(pos.offset(0, yOffset, 0));
        return state.is(AbyssTechBlocks.TUNING_CRYSTAL_EMBRACE) ? (((Boolean)state.getValue((Property)TuningCrystal.upgraded)).booleanValue() && canUseUpgrade ? upgradedRadius : tunedRadius) : baseRadius;
    }

    public static int vigorTuneDetect(Level level, BlockPos pos, int yOffset, boolean canUseUpgrade) {
        BlockState state = level.getBlockState(pos.offset(0, yOffset, 0));
        return state.is(AbyssTechBlocks.TUNING_CRYSTAL_VIGOR) ? (((Boolean)state.getValue((Property)TuningCrystal.upgraded)).booleanValue() && canUseUpgrade ? 2 : 1) : 0;
    }

    public static boolean vigorTuneDetect(Level level, BlockPos pos, int yOffset) {
        BlockState state = level.getBlockState(pos.offset(0, yOffset, 0));
        return state.is(AbyssTechBlocks.TUNING_CRYSTAL_VIGOR);
    }

    public static void SimpleDamageHeldItem(Level level, BlockPos pos, Player player, Item item) {
        if (player.getMainHandItem().is(item)) {
            if (player.getMainHandItem().getDamageValue() < player.getMainHandItem().getMaxDamage()) {
                player.getMainHandItem().setDamageValue(player.getMainHandItem().getDamageValue() + 1);
                if (player.getMainHandItem().getDamageValue() >= player.getMainHandItem().getMaxDamage()) {
                    player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    level.playSound(null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS);
                }
            }
        } else if (player.getOffhandItem().is(item) && player.getOffhandItem().getDamageValue() < player.getOffhandItem().getMaxDamage()) {
            player.getOffhandItem().setDamageValue(player.getOffhandItem().getDamageValue() + 1);
            if (player.getOffhandItem().getDamageValue() >= player.getOffhandItem().getMaxDamage()) {
                player.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                level.playSound(null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS);
            }
        }
    }

    public static void playerPlaceTakeItem(Level level, BlockPos pos, BlockState state, Container container, ItemStack stack, Player player) {
        if (container.isEmpty() && !stack.isEmpty()) {
            container.setItem(0, stack);
            stack.shrink(1);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
        } else if (stack.isEmpty() && !container.isEmpty()) {
            ItemStack stackInPedestal = container.getItem(0);
            container.clearContent();
            player.setItemInHand(InteractionHand.MAIN_HAND, stackInPedestal);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.sendBlockUpdated(pos, state, state, 3);
    }

    public static void randomPositiveEffect(Player player) {
        switch (random.nextInt(5)) {
            case 0: {
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 0));
                break;
            }
            case 1: {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 1));
                break;
            }
            case 2: {
                player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 100, 0));
                break;
            }
            case 3: {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 2400, 0));
                break;
            }
            case 4: {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0));
            }
        }
    }

    public static void randomNegativeEffect(Player player) {
        switch (random.nextInt(5)) {
            case 0: {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1200, 0));
                break;
            }
            case 1: {
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
                break;
            }
            case 2: {
                player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 0));
                break;
            }
            case 3: {
                player.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
                break;
            }
            case 4: {
                player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 60, 4));
            }
        }
    }

    public static Vec3 getLookPos(LivingEntity livingEntity, float distance) {
        return livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale((double)distance));
    }

    public static BlockPos getLookBlockPos(LivingEntity livingEntity, float distance) {
        Vec3 targetPos = livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale((double)distance));
        return new BlockPos((int)targetPos.x, (int)targetPos.y, (int)targetPos.z);
    }

    public static Vec3 getLookPosCollider(Level level, LivingEntity livingEntity, float collisionCheckStep, int distance) {
        Vec3 targetPos = new Vec3(0.0, 0.0, 0.0);
        for (float i = 0.0f; i < (float)distance; i += collisionCheckStep) {
            targetPos = livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale((double)i));
            BlockPos collisionCheck = new BlockPos((int)targetPos.x, (int)targetPos.y, (int)targetPos.z);
            if (level.getBlockState(collisionCheck).isAir()) continue;
            return targetPos;
        }
        return targetPos;
    }

    public static BlockPos getLookBlockPosCollider(Level level, LivingEntity livingEntity, float collisionCheckStep, int distance) {
        BlockPos collidedPos = new BlockPos(0, 0, 0);
        for (float i = 0.0f; i < (float)distance; i += collisionCheckStep) {
            Vec3 targetPos = livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale((double)i));
            collidedPos = new BlockPos((int)targetPos.x, (int)targetPos.y, (int)targetPos.z);
            if (level.getBlockState(collidedPos).isAir()) continue;
            return collidedPos;
        }
        return collidedPos;
    }

    public static void sendSimpleEffects(Level level, BlockPos pos, int particleCount, double yOffset, SimpleParticleType particleType, SoundEvent soundEvent) {
        ((ServerLevel)level).sendParticles((ParticleOptions)particleType, (double)pos.getX() + 0.5, (double)pos.getY() + yOffset, (double)pos.getZ() + 0.5, particleCount, 0.0, 0.0, 0.0, 0.0);
        level.playSound(null, pos, soundEvent, SoundSource.BLOCKS);
    }

    public static void dummyPlayerInteract(Level level, BlockPos pos, BlockPos tarPos) {
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer dummyPlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)DUMMY_PROFILE);
        dummyPlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        BlockHitResult hitResult = new BlockHitResult(Vec3.ZERO, Direction.DOWN, tarPos, false);
        InteractionResult result = dummyPlayer.gameMode.useItemOn((ServerPlayer)dummyPlayer, (Level)serverLevel, dummyPlayer.getMainHandItem(), InteractionHand.MAIN_HAND, hitResult);
        dummyPlayer.discard();
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Level level, BlockPos pos, Class<T> entity, int radius) {
        return level.getEntitiesOfClass(entity, new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius)));
    }

    public static void syncMovement(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
        }
    }

    public static int getDistOfTwoTargets(BlockPos posOne, BlockPos posTwo) {
        return (int)Math.sqrt(Math.pow(posOne.getX() - posTwo.getX(), 2.0) + Math.pow(posOne.getY() - posTwo.getY(), 2.0) + Math.pow(posOne.getZ() - posTwo.getZ(), 2.0));
    }

    public static List<BlockPos> getBlocksPosInCube(Level level, BlockPos pos, int radius, Block[] targetBlock, boolean singleSearch, boolean omitOriginPos) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        block0: for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    for (Block block : targetBlock) {
                        if (!level.getBlockState(pos.offset(x, y, z)).is(block) || omitOriginPos && pos.offset(x, y, z) == pos) continue;
                        posList.add(pos.offset(x, y, z));
                        if (singleSearch) break block0;
                    }
                }
            }
        }
        return posList;
    }

    public static List<BlockPos> getBlocksPosInCube(Level level, BlockPos pos, int radius, TagKey<Block> targetBlocks, boolean singleSearch) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        block0: for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    if (!level.getBlockState(pos.offset(x, y, z)).is(targetBlocks)) continue;
                    posList.add(pos.offset(x, y, z));
                    if (singleSearch) break block0;
                }
            }
        }
        return posList;
    }

    public static void updateItemRenderBooleanState(Level level, BlockState state, BlockPos pos, BooleanProperty boolProp, Container container) {
        if (((Boolean)state.getValue((Property)boolProp)).booleanValue()) {
            if (container.isEmpty()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)boolProp, (Comparable)Boolean.valueOf(false)));
            }
        } else if (!((Boolean)state.getValue((Property)boolProp)).booleanValue() && !container.isEmpty()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)boolProp, (Comparable)Boolean.valueOf(true)));
        }
    }
}

