/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.util.growth;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GrowthSet {
    private final TagKey<Block> replaceable;
    private final Supplier<Block> replaceableBlock;
    private final Supplier<Block[]> foliage;
    private final Supplier<Block[]> rareFoliage;
    private final Supplier<Block> mainSpreadingBlock;
    private final Supplier<Block[]> altBlocks;
    Random random = new Random();

    public GrowthSet(@Nullable Supplier<Block> mainSpreadingBlock, Supplier<Block> replaceable, @Nullable Supplier<Block[]> altSpreadingBlocks, @Nullable Supplier<Block[]> foliage, @Nullable Supplier<Block[]> rareFoliage) {
        this.mainSpreadingBlock = mainSpreadingBlock;
        this.replaceable = null;
        this.replaceableBlock = replaceable;
        this.altBlocks = altSpreadingBlocks;
        this.foliage = foliage;
        this.rareFoliage = rareFoliage;
    }

    public GrowthSet(@Nullable Supplier<Block> mainSpreadingBlock, TagKey<Block> replaceable, @Nullable Supplier<Block[]> altSpreadingBlocks, @Nullable Supplier<Block[]> foliage, @Nullable Supplier<Block[]> rareFoliage) {
        this.mainSpreadingBlock = mainSpreadingBlock;
        this.replaceable = replaceable;
        this.replaceableBlock = null;
        this.altBlocks = altSpreadingBlocks;
        this.foliage = foliage;
        this.rareFoliage = rareFoliage;
    }

    public boolean isReplaceableAtPos(Level level, BlockPos pos) {
        boolean toReturn = false;
        if (this.replaceable != null) {
            toReturn = level.getBlockState(pos).is(this.replaceable);
        }
        if (this.replaceableBlock != null) {
            toReturn = level.getBlockState(pos).is(this.replaceableBlock.get());
        }
        return toReturn;
    }

    public Block getRandomAltSpreadingBlock(int chance) {
        if (this.altBlocks != null && this.random.nextInt(chance) == 1) {
            return this.altBlocks.get()[this.random.nextInt(this.altBlocks.get().length)];
        }
        return this.mainSpreadingBlock != null ? this.mainSpreadingBlock.get() : null;
    }

    public Block getRandomFoliage() {
        if (this.foliage != null) {
            return this.foliage.get()[this.random.nextInt(this.foliage.get().length)];
        }
        return null;
    }

    public Block getRandomRareFoliage() {
        if (this.rareFoliage != null) {
            return this.rareFoliage.get()[this.random.nextInt(this.rareFoliage.get().length)];
        }
        return null;
    }
}

