/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.worldgen;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.quasar.abysstech.block.AbyssTechBlocks;

public class AbysstechConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRAL_KEY = AbysstechConfiguredFeatures.registerKey("spiral");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BARROW_KEY = AbysstechConfiguredFeatures.registerKey("barrow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WINDSWEPT_KEY = AbysstechConfiguredFeatures.registerKey("windswept");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        AbysstechConfiguredFeatures.register(context, SPIRAL_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.SPIRAL_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(8, 3, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.SPIRAL_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)1), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AbysstechConfiguredFeatures.register(context, BARROW_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.BARROW_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(8, 3, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.BARROW_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)1), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AbysstechConfiguredFeatures.register(context, WINDSWEPT_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.WINDSWEPT_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(8, 3, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)AbyssTechBlocks.WINDSWEPT_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)1), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

