/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;

public class SummonerSkeletonModel<S extends IllagerRenderState>
extends EntityModel<S>
implements ArmedModel,
HeadedModel {
    private final ModelPart SummonerSkeleton;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart arms;
    private final ModelPart arms_rotation;
    private final ModelPart arms_flipped;
    private final ModelPart body;

    public SummonerSkeletonModel(ModelPart root) {
        super(root);
        this.SummonerSkeleton = root.getChild("SummonerSkeleton");
        this.head = this.SummonerSkeleton.getChild("head");
        this.rightLeg = this.SummonerSkeleton.getChild("right_leg");
        this.leftLeg = this.SummonerSkeleton.getChild("left_leg");
        this.rightArm = this.SummonerSkeleton.getChild("right_arm");
        this.leftArm = this.SummonerSkeleton.getChild("left_arm");
        this.arms = this.SummonerSkeleton.getChild("arms");
        this.arms_rotation = this.arms.getChild("arms_rotation");
        this.arms_flipped = this.arms_rotation.getChild("arms_flipped");
        this.body = this.SummonerSkeleton.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition SummonerSkeleton2 = partdefinition.addOrReplaceChild("SummonerSkeleton", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = SummonerSkeleton2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition right_leg = SummonerSkeleton2.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_leg = SummonerSkeleton2.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_arm = SummonerSkeleton2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition left_arm = SummonerSkeleton2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition arms = SummonerSkeleton2.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-20.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.addOrReplaceChild("arms_rotation", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, 0.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 38).addBox(-4.0f, 4.0f, -2.05f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        PartDefinition arms_flipped = arms_rotation.addOrReplaceChild("arms_flipped", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -24.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = SummonerSkeleton2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(S p_366958_) {
        boolean $$4;
        super.setupAnim(p_366958_);
        this.head.yRot = ((IllagerRenderState)p_366958_).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((IllagerRenderState)p_366958_).xRot * ((float)Math.PI / 180);
        if (((IllagerRenderState)p_366958_).isRiding) {
            this.rightArm.xRot = -0.62831855f;
            this.rightArm.yRot = 0.0f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.xRot = -0.62831855f;
            this.leftArm.yRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        } else {
            float $$1 = ((IllagerRenderState)p_366958_).walkAnimationSpeed;
            float $$2 = ((IllagerRenderState)p_366958_).walkAnimationPos;
            this.rightArm.xRot = Mth.cos((float)($$2 * 0.6662f + (float)Math.PI)) * 2.0f * $$1 * 0.5f;
            this.rightArm.yRot = 0.0f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.xRot = Mth.cos((float)($$2 * 0.6662f)) * 2.0f * $$1 * 0.5f;
            this.leftArm.yRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightLeg.xRot = Mth.cos((float)($$2 * 0.6662f)) * 1.4f * $$1 * 0.5f;
            this.rightLeg.yRot = 0.0f;
            this.rightLeg.zRot = 0.0f;
            this.leftLeg.xRot = Mth.cos((float)($$2 * 0.6662f + (float)Math.PI)) * 1.4f * $$1 * 0.5f;
            this.leftLeg.yRot = 0.0f;
            this.leftLeg.zRot = 0.0f;
        }
        AbstractIllager.IllagerArmPose $$3 = ((IllagerRenderState)p_366958_).armPose;
        if ($$3 == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (p_366958_.getMainHandItem().isEmpty()) {
                AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)((IllagerRenderState)p_366958_).attackAnim, (float)((IllagerRenderState)p_366958_).ageInTicks);
            } else {
                AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (HumanoidArm)((IllagerRenderState)p_366958_).mainArm, (float)((IllagerRenderState)p_366958_).attackAnim, (float)((IllagerRenderState)p_366958_).ageInTicks);
            }
        } else if ($$3 == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.rightArm.z = 0.0f;
            this.rightArm.x = -5.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.x = 5.0f;
            this.rightArm.xRot = Mth.cos((float)(((IllagerRenderState)p_366958_).ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.xRot = Mth.cos((float)(((IllagerRenderState)p_366958_).ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.zRot = 2.3561945f;
            this.leftArm.zRot = -2.3561945f;
            this.rightArm.yRot = 0.0f;
            this.leftArm.yRot = 0.0f;
        } else if ($$3 == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.rightArm.yRot = -0.1f + this.head.yRot;
            this.rightArm.xRot = -1.5707964f + this.head.xRot;
            this.leftArm.xRot = -0.9424779f + this.head.xRot;
            this.leftArm.yRot = this.head.yRot - 0.4f;
            this.leftArm.zRot = 1.5707964f;
        } else if ($$3 == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
        } else if ($$3 == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)((IllagerRenderState)p_366958_).maxCrossbowChargeDuration, (int)((IllagerRenderState)p_366958_).ticksUsingItem, (boolean)true);
        } else if ($$3 == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.rightArm.z = 0.0f;
            this.rightArm.x = -5.0f;
            this.rightArm.xRot = Mth.cos((float)(((IllagerRenderState)p_366958_).ageInTicks * 0.6662f)) * 0.05f;
            this.rightArm.zRot = 2.670354f;
            this.rightArm.yRot = 0.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.x = 5.0f;
            this.leftArm.xRot = Mth.cos((float)(((IllagerRenderState)p_366958_).ageInTicks * 0.6662f)) * 0.05f;
            this.leftArm.zRot = -2.3561945f;
            this.leftArm.yRot = 0.0f;
        }
        this.arms.visible = $$4 = $$3 == AbstractIllager.IllagerArmPose.CROSSED;
        this.leftArm.visible = !$$4;
        this.rightArm.visible = !$$4;
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.root.translateAndRotate(p_102926_);
        this.getArm(p_102925_).translateAndRotate(p_102926_);
    }
}

