/*
 * Decompiled with CFR 0.152.
 */
package net.baffeldbanana87.netherdungeon;

import com.mojang.logging.LogUtils;
import net.baffeldbanana87.block.ModBlock;
import net.baffeldbanana87.entity.ModEntities;
import net.baffeldbanana87.entity.client.CryingSkeletonRenderer;
import net.baffeldbanana87.entity.client.DyingSkeletonRenderer;
import net.baffeldbanana87.entity.client.MegaWitherSkeletonRenderer;
import net.baffeldbanana87.entity.client.SummonerSkeletonRenderer;
import net.baffeldbanana87.entity.client.WitherVexRenderer;
import net.baffeldbanana87.item.ModItems;
import net.baffeldbanana87.netherdungeon.Config;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="netherdungeon")
public class NetherDungeon {
    public static final String MOD_ID = "netherdungeon";
    private static final Logger LOGGER = LogUtils.getLogger();

    public NetherDungeon(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModBlock.register(modEventBus);
        ModEntities.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ModItems.CRYING_INGOT);
            event.accept(ModItems.CRYING_UPGRADER);
            event.accept(ModItems.BLOOD);
            event.accept(ModItems.SUMMONER_EYE);
        }
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(ModItems.EGGSTAFF);
            event.accept(ModItems.FIRESTAFF);
            event.accept(ModItems.SNOWSTAFF);
            event.accept(ModItems.BLOOD_STAINED_AXE);
            event.accept(ModItems.BLOOD_STAINED_SWORD);
            event.accept(ModItems.CRYING_LEGGINGS);
            event.accept(ModItems.CRYING_BOOTS);
            event.accept(ModItems.CRYING_CHESTPLATE);
            event.accept(ModItems.CRYING_HELMETS);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.BLOOD_STAINED_AXE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="netherdungeon", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register((EntityType)((EntityType)ModEntities.DYING_SKELETON.get()), DyingSkeletonRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.MEGA_WITHER_SKELETON.get()), MegaWitherSkeletonRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.SUMMONER_SKELETON.get()), SummonerSkeletonRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.WITHER_VEX.get()), WitherVexRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.CRYING_SKELETON.get()), CryingSkeletonRenderer::new);
        }
    }
}

