/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.baffledbanana87.entity.custom.MegaWitherSkeleton;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractSkeletonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MegaWitherSkeletonRenderer
extends AbstractSkeletonRenderer<MegaWitherSkeleton, SkeletonRenderState> {
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png");
    private static final ResourceLocation WITHER_SKELETON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"netherdungeon", (String)"textures/entity/mega_wither_skeleton.png");

    public MegaWitherSkeletonRenderer(EntityRendererProvider.Context p_174447_) {
        super(p_174447_, ModelLayers.WITHER_SKELETON, ModelLayers.WITHER_SKELETON_INNER_ARMOR, ModelLayers.WITHER_SKELETON_OUTER_ARMOR);
    }

    public SkeletonRenderState createRenderState() {
        return new SkeletonRenderState();
    }

    public ResourceLocation getTextureLocation(SkeletonRenderState megaSkeletonState) {
        int $$1 = Mth.floor((float)megaSkeletonState.ageInTicks);
        return $$1 > 0 && ($$1 > 80 || $$1 / 5 % 2 != 1) ? WITHER_SKELETON_LOCATION : WITHER_INVULNERABLE_LOCATION;
    }

    protected void scale(SkeletonRenderState p_370233_, PoseStack p_116434_) {
        float $$2 = 1.5f;
        if (p_370233_.ageInTicks < 80.0f) {
            $$2 += p_370233_.ageInTicks / 220.0f * 0.5f;
        }
        p_116434_.scale($$2, $$2, $$2);
    }
}

