/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.baffledbanana87.entity.ModEntities;
import net.baffledbanana87.entity.custom.CryingSkeletonEntity;
import net.baffledbanana87.entity.custom.WitherVex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.ForgeEventFactory;

public class SummonerSkeleton
extends SpellcasterIllager {
    @Nullable
    private Sheep wololoTarget;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    protected void readAdditionalSaveData(ValueInput p_410617_) {
        super.readAdditionalSaveData(p_410617_);
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossEvent.setName(this.getDisplayName());
    }

    public SummonerSkeleton(EntityType<? extends SummonerSkeleton> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EvokerCastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new EvokerSummonSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new EvokerAttackSpellGoal());
        this.goalSelector.addGoal(6, (Goal)new EvokerWololoSpellGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void applyRaidBuffs(ServerLevel pLevel, int pWave, boolean pUnused) {
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 500.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    void setWololoTarget(@Nullable Sheep p_395898_) {
        this.wololoTarget = p_395898_;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected void customServerAiStep(ServerLevel p_363567_) {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    class EvokerCastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        EvokerCastingSpellGoal() {
            super((SpellcasterIllager)SummonerSkeleton.this);
        }

        public void tick() {
            if (SummonerSkeleton.this.getTarget() != null) {
                SummonerSkeleton.this.getLookControl().setLookAt((Entity)SummonerSkeleton.this.getTarget(), (float)SummonerSkeleton.this.getMaxHeadYRot(), (float)SummonerSkeleton.this.getMaxHeadXRot());
            } else if (SummonerSkeleton.this.getWololoTarget() != null) {
                SummonerSkeleton.this.getLookControl().setLookAt((Entity)SummonerSkeleton.this.getWololoTarget(), (float)SummonerSkeleton.this.getMaxHeadYRot(), (float)SummonerSkeleton.this.getMaxHeadXRot());
            }
        }
    }

    class EvokerSummonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions vexCountTargeting;

        EvokerSummonSpellGoal() {
            super((SpellcasterIllager)SummonerSkeleton.this);
            this.vexCountTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = EvokerSummonSpellGoal.getServerLevel((Level)SummonerSkeleton.this.level()).getNearbyEntities(Vex.class, this.vexCountTargeting, (LivingEntity)SummonerSkeleton.this, SummonerSkeleton.this.getBoundingBox().inflate(16.0)).size();
            return SummonerSkeleton.this.random.nextInt(8) + 1 > i;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            BlockPos blockpos;
            ServerLevel serverlevel = (ServerLevel)SummonerSkeleton.this.level();
            PlayerTeam playerteam = SummonerSkeleton.this.getTeam();
            for (int i = 0; i < 3; ++i) {
                blockpos = SummonerSkeleton.this.blockPosition().offset(-2 + SummonerSkeleton.this.random.nextInt(5), 1, -2 + SummonerSkeleton.this.random.nextInt(5));
                WitherVex vex = (WitherVex)((EntityType)ModEntities.WITHER_VEX.get()).create(SummonerSkeleton.this.level(), EntitySpawnReason.MOB_SUMMONED);
                if (vex == null) continue;
                vex.snapTo(blockpos, 0.0f, 0.0f);
                vex.finalizeSpawn((ServerLevelAccessor)serverlevel, SummonerSkeleton.this.level().getCurrentDifficultyAt(blockpos), EntitySpawnReason.MOB_SUMMONED, null);
                vex.setOwner((Mob)SummonerSkeleton.this);
                vex.setBoundOrigin(blockpos);
                vex.setLimitedLife(20 * (30 + SummonerSkeleton.this.random.nextInt(90)));
                if (playerteam != null) {
                    serverlevel.getScoreboard().addPlayerToTeam(vex.getScoreboardName(), playerteam);
                }
                serverlevel.addFreshEntityWithPassengers((Entity)vex);
                serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)SummonerSkeleton.this));
            }
            for (int j = 0; j < 2; ++j) {
                blockpos = SummonerSkeleton.this.blockPosition().offset(-2 + SummonerSkeleton.this.random.nextInt(5), 1, -2 + SummonerSkeleton.this.random.nextInt(5));
                CryingSkeletonEntity cryingskeleton = (CryingSkeletonEntity)((EntityType)ModEntities.CRYING_SKELETON.get()).create(SummonerSkeleton.this.level(), EntitySpawnReason.MOB_SUMMONED);
                if (cryingskeleton == null) continue;
                cryingskeleton.snapTo(blockpos, 0.0f, 0.0f);
                cryingskeleton.finalizeSpawn((ServerLevelAccessor)serverlevel, SummonerSkeleton.this.level().getCurrentDifficultyAt(blockpos), EntitySpawnReason.MOB_SUMMONED, null);
                if (playerteam != null) {
                    serverlevel.getScoreboard().addPlayerToTeam(cryingskeleton.getScoreboardName(), playerteam);
                }
                serverlevel.addFreshEntityWithPassengers((Entity)cryingskeleton);
                serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)SummonerSkeleton.this));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class EvokerAttackSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        EvokerAttackSpellGoal() {
            super((SpellcasterIllager)SummonerSkeleton.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected void performSpellCasting() {
            LivingEntity livingentity = SummonerSkeleton.this.getTarget();
            double d0 = Math.min(livingentity.getY(), SummonerSkeleton.this.getY());
            double d1 = Math.max(livingentity.getY(), SummonerSkeleton.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingentity.getZ() - SummonerSkeleton.this.getZ()), (double)(livingentity.getX() - SummonerSkeleton.this.getX()));
            if (SummonerSkeleton.this.distanceToSqr((Entity)livingentity) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.createSpellEntity(SummonerSkeleton.this.getX() + (double)Mth.cos((float)f1) * 1.5, SummonerSkeleton.this.getZ() + (double)Mth.sin((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createSpellEntity(SummonerSkeleton.this.getX() + (double)Mth.cos((float)f2) * 2.5, SummonerSkeleton.this.getZ() + (double)Mth.sin((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.createSpellEntity(SummonerSkeleton.this.getX() + (double)Mth.cos((float)f) * d2, SummonerSkeleton.this.getZ() + (double)Mth.sin((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void createSpellEntity(double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
            BlockPos blockpos = BlockPos.containing((double)pX, (double)pMaxY, (double)pZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = SummonerSkeleton.this.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)SummonerSkeleton.this.level(), blockpos1, Direction.UP)) continue;
                if (!SummonerSkeleton.this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = SummonerSkeleton.this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)SummonerSkeleton.this.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)pMinY) - 1);
            if (flag) {
                SummonerSkeleton.this.level().addFreshEntity((Entity)new EvokerFangs(SummonerSkeleton.this.level(), pX, (double)blockpos.getY() + d0, pZ, pYRot, pWarmupDelay, (LivingEntity)SummonerSkeleton.this));
                SummonerSkeleton.this.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, new Vec3(pX, (double)blockpos.getY() + d0, pZ), GameEvent.Context.of((Entity)SummonerSkeleton.this));
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class EvokerWololoSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting;

        public EvokerWololoSpellGoal() {
            super((SpellcasterIllager)SummonerSkeleton.this);
            this.wololoTargeting = TargetingConditions.forNonCombat().range(16.0).selector((p_32710_, p_361874_) -> ((Sheep)p_32710_).getColor() == DyeColor.BLUE);
        }

        public boolean canUse() {
            if (SummonerSkeleton.this.getTarget() != null) {
                return false;
            }
            if (SummonerSkeleton.this.isCastingSpell()) {
                return false;
            }
            if (SummonerSkeleton.this.tickCount < this.nextAttackTickCount) {
                return false;
            }
            ServerLevel serverlevel = EvokerWololoSpellGoal.getServerLevel((Level)SummonerSkeleton.this.level());
            if (!ForgeEventFactory.getMobGriefingEvent((ServerLevel)serverlevel, (Entity)SummonerSkeleton.this)) {
                return false;
            }
            List list = serverlevel.getNearbyEntities(Sheep.class, this.wololoTargeting, (LivingEntity)SummonerSkeleton.this, SummonerSkeleton.this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            SummonerSkeleton.this.setWololoTarget((Sheep)list.get(SummonerSkeleton.this.random.nextInt(list.size())));
            return true;
        }

        public boolean canContinueToUse() {
            return SummonerSkeleton.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void stop() {
            super.stop();
            SummonerSkeleton.this.setWololoTarget(null);
        }

        protected void performSpellCasting() {
            Sheep sheep = SummonerSkeleton.this.getWololoTarget();
            if (sheep != null && sheep.isAlive()) {
                sheep.setColor(DyeColor.RED);
            }
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_WOLOLO;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

