/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.netherdungeon;

import com.mojang.logging.LogUtils;
import net.baffledbanana87.block.ModBlock;
import net.baffledbanana87.entity.ModEntities;
import net.baffledbanana87.entity.client.CryingSkeletonRenderer;
import net.baffledbanana87.entity.client.DyingSkeletonRenderer;
import net.baffledbanana87.entity.client.MegaWitherSkeletonRenderer;
import net.baffledbanana87.entity.client.SummonerSkeletonRenderer;
import net.baffledbanana87.entity.client.WitherVexRenderer;
import net.baffledbanana87.item.ModItems;
import net.baffledbanana87.netherdungeon.Config;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="netherdungeon")
public final class NetherDungeon {
    public static final String MOD_ID = "netherdungeon";
    private static final Logger LOGGER = LogUtils.getLogger();

    public NetherDungeon(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        ModItems.register(modBusGroup);
        ModBlock.register(modBusGroup);
        ModEntities.register(modBusGroup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(event -> {
                EntityRenderers.register((EntityType)((EntityType)ModEntities.DYING_SKELETON.get()), DyingSkeletonRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.MEGA_WITHER_SKELETON.get()), MegaWitherSkeletonRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.SUMMONER_SKELETON.get()), SummonerSkeletonRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.WITHER_VEX.get()), WitherVexRenderer::new);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.CRYING_SKELETON.get()), CryingSkeletonRenderer::new);
            });
        }
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modBusGroup).addListener(NetherDungeon::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ModItems.CRYING_INGOT);
            event.accept(ModItems.CRYING_UPGRADER);
            event.accept(ModItems.BLOOD);
            event.accept(ModItems.SUMMONER_EYE);
        }
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(ModItems.EGGSTAFF);
            event.accept(ModItems.FIRESTAFF);
            event.accept(ModItems.SNOWSTAFF);
            event.accept(ModItems.BLOOD_STAINED_AXE);
            event.accept(ModItems.BLOOD_STAINED_SWORD);
            event.accept(ModItems.CRYING_LEGGINGS);
            event.accept(ModItems.CRYING_BOOTS);
            event.accept(ModItems.CRYING_CHESTPLATE);
            event.accept(ModItems.CRYING_HELMETS);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.BLOOD_STAINED_AXE);
        }
    }

    @Mod.EventBusSubscriber(modid="netherdungeon", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

