/*
 * Decompiled with CFR 0.152.
 */
package net.baffledbanana87.entity.custom;

import javax.annotation.Nullable;
import net.baffledbanana87.entity.custom.DyingAttackGoal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

public class DyingSkeleton
extends Monster {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossEvent.setName(this.getDisplayName());
    }

    public DyingSkeleton(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, (Goal)new DyingAttackGoal(this, 1.6, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{ZombifiedPiglin.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34178_, DifficultyInstance p_34179_, EntitySpawnReason p_368639_, @Nullable SpawnGroupData p_34181_) {
        SpawnGroupData $$4 = super.finalizeSpawn(p_34178_, p_34179_, p_368639_, p_34181_);
        return $$4;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 650.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.ATTACK_DAMAGE, 24.0).add(Attributes.ATTACK_SPEED, 5.0).add(Attributes.MOVEMENT_SPEED, 0.15);
    }

    public void tick() {
        super.tick();
        this.SpeedChange();
    }

    public void SpeedChange() {
        if (this.getHealth() < 600.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(25.0);
        } else if (this.getHealth() < 500.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.35);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(26.0);
        } else if (this.getHealth() < 400.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.45);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(27.0);
        } else if (this.getHealth() < 300.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.55);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(28.0);
        } else if (this.getHealth() < 200.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.65);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(29.0);
        } else if (this.getHealth() < 100.0f) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.75);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(30.0);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.WITHER_SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_SKELETON_DEATH;
    }

    protected void customServerAiStep(ServerLevel p_363567_) {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }
}

