/*
 * Decompiled with CFR 0.152.
 */
package net.baffeldbanana87.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.baffeldbanana87.entity.custom.MegaWitherSkeleton;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MegaWitherSkeletonRenderer
extends HumanoidMobRenderer<MegaWitherSkeleton, SkeletonModel<MegaWitherSkeleton>> {
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    private static final ResourceLocation WITHER_SKELETON_LOCATION = new ResourceLocation("netherdungeon", "textures/entity/mega_wither_skeleton.png");

    public MegaWitherSkeletonRenderer(EntityRendererProvider.Context p_174380_) {
        this(p_174380_, ModelLayers.f_171216_, ModelLayers.f_171217_, ModelLayers.f_171218_);
    }

    public MegaWitherSkeletonRenderer(EntityRendererProvider.Context pContext, ModelLayerLocation pSkeletonLayer, ModelLayerLocation pInnerModelLayer, ModelLayerLocation pOuterModelLayer) {
        super(pContext, (HumanoidModel)new SkeletonModel(pContext.m_174023_(pSkeletonLayer)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new SkeletonModel(pContext.m_174023_(pInnerModelLayer)), (HumanoidModel)new SkeletonModel(pContext.m_174023_(pOuterModelLayer)), pContext.m_266367_()));
    }

    public ResourceLocation getTextureLocation(MegaWitherSkeleton pEntity) {
        int i = pEntity.getInvulnerableTicks();
        return i > 0 && (i > 80 || i / 5 % 2 != 1) ? WITHER_INVULNERABLE_LOCATION : WITHER_SKELETON_LOCATION;
    }

    protected void scale(MegaWitherSkeleton pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        float f = 1.5f;
        int i = pLivingEntity.getInvulnerableTicks();
        if (i > 0) {
            f -= ((float)i - pPartialTickTime) / 220.0f * 0.5f;
        }
        pPoseStack.m_85841_(f, f, f);
    }
}

