/*
 * Decompiled with CFR 0.152.
 */
package de.todomc;

import de.todomc.commands.TodoCommand;
import de.todomc.listeners.ChatListener;
import de.todomc.listeners.GuiListener;
import de.todomc.managers.TaskManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TodoPlugin
extends JavaPlugin {
    private static TodoPlugin instance;
    private TaskManager taskManager;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.taskManager = new TaskManager(this);
        this.taskManager.loadTasks();
        this.getCommand("todo").setExecutor((CommandExecutor)new TodoCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getLogger().info("TodoPlugin wurde erfolgreich aktiviert!");
    }

    public void onDisable() {
        if (this.taskManager != null) {
            this.taskManager.saveTasks();
        }
        this.getLogger().info("TodoPlugin wurde deaktiviert!");
    }

    public static TodoPlugin getInstance() {
        return instance;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }
}

