/*
 * Decompiled with CFR 0.152.
 */
package de.todomc.commands;

import de.todomc.TodoPlugin;
import de.todomc.gui.TodoGUI;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TodoCommand
implements CommandExecutor {
    private final TodoPlugin plugin;

    public TodoCommand(TodoPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cDieser Befehl kann nur von Spielern ausgef\u00fchrt werden!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("todo.use")) {
            player.sendMessage("\u00a7cDu hast keine Berechtigung f\u00fcr diesen Befehl!");
            return true;
        }
        if (args.length > 0 && (args[0].equalsIgnoreCase("cancel") || args[0].equalsIgnoreCase("skip"))) {
            if (this.plugin.getTaskManager().isPlayerInCreateMode(player.getUniqueId().toString())) {
                this.plugin.getTaskManager().removePlayerFromCreateMode(player.getUniqueId().toString());
                player.sendMessage("\u00a7c\u00a7lAbgebrochen! \u00a77Aufgaben-Erstellung wurde abgebrochen.");
            }
            return true;
        }
        TodoGUI gui = new TodoGUI(this.plugin, player);
        gui.openMainMenu();
        return true;
    }
}

