/*
 * Decompiled with CFR 0.152.
 */
package de.todomc.gui;

import de.todomc.TodoPlugin;
import de.todomc.models.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class TodoGUI {
    private final TodoPlugin plugin;
    private final Player player;
    private int currentPage = 0;
    private static final int TASKS_PER_PAGE = 21;

    public TodoGUI(TodoPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void openMainMenu() {
        List<Task> playerTasks = this.plugin.getTaskManager().getTasksForPlayer(this.player.getUniqueId().toString());
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7lTo-Do Liste \u00a77(Seite " + (this.currentPage + 1) + ")"));
        inv.setItem(45, this.createItem(Material.ARROW, "\u00a7a\u00a7lVorherige Seite", Arrays.asList("\u00a77Klicke um zur vorherigen", "\u00a77Seite zu wechseln")));
        inv.setItem(53, this.createItem(Material.ARROW, "\u00a7a\u00a7lN\u00e4chste Seite", Arrays.asList("\u00a77Klicke um zur n\u00e4chsten", "\u00a77Seite zu wechseln")));
        inv.setItem(49, this.createItem(Material.WRITABLE_BOOK, "\u00a7e\u00a7lNeue Aufgabe erstellen", Arrays.asList("\u00a77Klicke um eine neue", "\u00a77Aufgabe hinzuzuf\u00fcgen")));
        inv.setItem(48, this.createItem(Material.PLAYER_HEAD, "\u00a7b\u00a7lAlle Aufgaben anzeigen", Arrays.asList("\u00a77Zeigt alle serverweit", "\u00a77erstellten Aufgaben an")));
        inv.setItem(50, this.createItem(Material.COMPASS, "\u00a7d\u00a7lVon mir erstellte Aufgaben", Arrays.asList("\u00a77Zeigt alle von dir", "\u00a77erstellten Aufgaben an")));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (int i = 45; i < 54; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
        int startIndex = this.currentPage * 21;
        int endIndex = Math.min(startIndex + 21, playerTasks.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Task task = playerTasks.get(i);
            ItemStack taskItem = this.createTaskItem(task);
            inv.setItem(i - startIndex, taskItem);
        }
        this.player.openInventory(inv);
    }

    public void openAllTasksMenu() {
        if (!this.player.hasPermission("todo.admin")) {
            this.player.sendMessage("\u00a7cDu hast keine Berechtigung, alle Aufgaben zu sehen!");
            return;
        }
        List<Task> allTasks = this.plugin.getTaskManager().getAllTasks();
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7lAlle Aufgaben \u00a77(Seite " + (this.currentPage + 1) + ")"));
        inv.setItem(45, this.createItem(Material.ARROW, "\u00a7a\u00a7lVorherige Seite", Arrays.asList("\u00a77Klicke um zur vorherigen", "\u00a77Seite zu wechseln")));
        inv.setItem(53, this.createItem(Material.ARROW, "\u00a7a\u00a7lN\u00e4chste Seite", Arrays.asList("\u00a77Klicke um zur n\u00e4chsten", "\u00a77Seite zu wechseln")));
        inv.setItem(49, this.createItem(Material.BARRIER, "\u00a7c\u00a7lZur\u00fcck", Arrays.asList("\u00a77Zur\u00fcck zur Hauptseite")));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (int i = 45; i < 54; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
        int startIndex = this.currentPage * 21;
        int endIndex = Math.min(startIndex + 21, allTasks.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Task task = allTasks.get(i);
            ItemStack taskItem = this.createTaskItem(task);
            inv.setItem(i - startIndex, taskItem);
        }
        this.player.openInventory(inv);
    }

    public void openMyTasksMenu() {
        List<Task> myTasks = this.plugin.getTaskManager().getTasksCreatedBy(this.player.getUniqueId().toString());
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7lMeine erstellten Aufgaben \u00a77(Seite " + (this.currentPage + 1) + ")"));
        inv.setItem(45, this.createItem(Material.ARROW, "\u00a7a\u00a7lVorherige Seite", Arrays.asList("\u00a77Klicke um zur vorherigen", "\u00a77Seite zu wechseln")));
        inv.setItem(53, this.createItem(Material.ARROW, "\u00a7a\u00a7lN\u00e4chste Seite", Arrays.asList("\u00a77Klicke um zur n\u00e4chsten", "\u00a77Seite zu wechseln")));
        inv.setItem(49, this.createItem(Material.BARRIER, "\u00a7c\u00a7lZur\u00fcck", Arrays.asList("\u00a77Zur\u00fcck zur Hauptseite")));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", Arrays.asList(new String[0]));
        for (int i = 45; i < 54; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, filler);
        }
        int startIndex = this.currentPage * 21;
        int endIndex = Math.min(startIndex + 21, myTasks.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Task task = myTasks.get(i);
            ItemStack taskItem = this.createTaskItem(task);
            inv.setItem(i - startIndex, taskItem);
        }
        this.player.openInventory(inv);
    }

    private ItemStack createTaskItem(Task task) {
        Material material = task.isCompleted() ? Material.LIME_CONCRETE : Material.RED_CONCRETE;
        String statusColor = task.isCompleted() ? "\u00a7a" : "\u00a7c";
        String status = task.isCompleted() ? "Erledigt" : "Offen";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Status: " + statusColor + status);
        lore.add("\u00a77Beschreibung: \u00a7f" + task.getDescription());
        lore.add("\u00a77Erstellt von: \u00a7e" + this.getPlayerName(task.getCreatedBy()));
        lore.add("\u00a77Zugewiesen an: \u00a7e" + this.getPlayerName(task.getAssignedTo()));
        lore.add("\u00a77Erstellt am: \u00a7f" + task.getFormattedCreatedAt());
        if (task.isCompleted() && task.getCompletedAt() != null) {
            lore.add("\u00a77Erledigt am: \u00a7f" + task.getFormattedCompletedAt());
        }
        lore.add("");
        lore.add("\u00a7e\u00a7lAktionen:");
        lore.add("\u00a77\u25b8 Linksklick: Status \u00e4ndern");
        lore.add("\u00a77\u25b8 Rechtsklick: L\u00f6schen");
        lore.add("\u00a77\u25b8 Shift+Linksklick: Zuweisen");
        return this.createItem(material, "\u00a76\u00a7l" + task.getTitle(), lore);
    }

    private String getPlayerName(String uuid) {
        Player player = Bukkit.getPlayer((String)uuid);
        if (player != null) {
            return player.getName();
        }
        try {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)).getName();
        }
        catch (IllegalArgumentException e) {
            return uuid;
        }
    }

    public void openNewTaskAnvil() {
        this.player.closeInventory();
        this.player.sendMessage("\u00a76\u00a7l=== Neue Aufgabe erstellen ===");
        this.player.sendMessage("\u00a7eBitte gib den Titel der Aufgabe im Chat ein:");
        this.player.sendMessage("\u00a77(Verwende \u00a7c/todo cancel\u00a77 zum Abbrechen)");
        this.plugin.getTaskManager().setPlayerInCreateMode(this.player.getUniqueId().toString(), "title");
    }

    private void openDescriptionAnvil(String title) {
        this.player.sendMessage("\u00a76\u00a7l=== Beschreibung hinzuf\u00fcgen ===");
        this.player.sendMessage("\u00a7eBitte gib eine Beschreibung f\u00fcr '\u00a7f" + title + "\u00a7e' im Chat ein:");
        this.player.sendMessage("\u00a77(Verwende \u00a7c/todo cancel\u00a77 zum Abbrechen oder \u00a7a/todo skip\u00a77 zum \u00dcberspringen)");
        this.plugin.getTaskManager().setPlayerInCreateMode(this.player.getUniqueId().toString(), "description:" + title);
    }

    public void handleChatInput(String message) {
        String mode = this.plugin.getTaskManager().getPlayerCreateMode(this.player.getUniqueId().toString());
        if (mode == null) {
            return;
        }
        if (message.equalsIgnoreCase("/todo cancel")) {
            this.plugin.getTaskManager().removePlayerFromCreateMode(this.player.getUniqueId().toString());
            this.player.sendMessage("\u00a7c\u00a7lAbgebrochen! \u00a77Aufgaben-Erstellung wurde abgebrochen.");
            this.openMainMenu();
            return;
        }
        if (mode.equals("title")) {
            if (message.trim().isEmpty()) {
                this.player.sendMessage("\u00a7cDer Titel darf nicht leer sein! Versuche es erneut:");
                return;
            }
            this.openDescriptionAnvil(message.trim());
            return;
        }
        if (mode.startsWith("description:")) {
            String title = mode.substring(12);
            String description = message.equalsIgnoreCase("/todo skip") || message.trim().isEmpty() ? "Keine Beschreibung" : message.trim();
            Task newTask = new Task(title, description, this.player.getUniqueId().toString());
            this.plugin.getTaskManager().addTask(newTask);
            this.plugin.getTaskManager().removePlayerFromCreateMode(this.player.getUniqueId().toString());
            this.player.sendMessage("\u00a7a\u00a7lAufgabe erstellt! \u00a77'" + title + "' wurde hinzugef\u00fcgt.");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openMainMenu(), 5L);
        }
    }

    public void openAssignMenu(String taskId) {
        Task task = this.plugin.getTaskManager().getTask(taskId);
        if (task == null) {
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76Aufgabe zuweisen: " + task.getTitle()));
        int slot = 0;
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (slot >= 45) break;
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)onlinePlayer);
            meta.setDisplayName("\u00a7e" + onlinePlayer.getName());
            meta.setLore(Arrays.asList("\u00a77Klicke um die Aufgabe", "\u00a77diesem Spieler zuzuweisen"));
            playerHead.setItemMeta((ItemMeta)meta);
            inv.setItem(slot++, playerHead);
        }
        inv.setItem(49, this.createItem(Material.BARRIER, "\u00a7c\u00a7lZur\u00fcck", Arrays.asList("\u00a77Zur\u00fcck zur Aufgabenliste")));
        this.player.openInventory(inv);
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        this.currentPage = Math.max(0, page);
    }
}

