/*
 * Decompiled with CFR 0.152.
 */
package de.todomc.listeners;

import de.todomc.TodoPlugin;
import de.todomc.gui.TodoGUI;
import de.todomc.models.Task;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class GuiListener
implements Listener {
    private final TodoPlugin plugin;

    public GuiListener(TodoPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!(title.contains("To-Do Liste") || title.contains("Aufgaben") || title.contains("zuweisen"))) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        TodoGUI gui = new TodoGUI(this.plugin, player);
        ItemStack clickedItem = event.getCurrentItem();
        if (title.contains("To-Do Liste")) {
            this.handleMainMenu(event, player, gui);
        } else if (title.contains("Alle Aufgaben")) {
            this.handleAllTasksMenu(event, player, gui);
        } else if (title.contains("Meine erstellten Aufgaben")) {
            this.handleMyTasksMenu(event, player, gui);
        } else if (title.contains("zuweisen")) {
            this.handleAssignMenu(event, player, gui, title);
        }
    }

    private void handleMainMenu(InventoryClickEvent event, Player player, TodoGUI gui) {
        ItemStack item = event.getCurrentItem();
        String displayName = item.getItemMeta().getDisplayName();
        switch (event.getSlot()) {
            case 45: {
                if (gui.getCurrentPage() <= 0) break;
                gui.setCurrentPage(gui.getCurrentPage() - 1);
                gui.openMainMenu();
                break;
            }
            case 53: {
                List<Task> playerTasks = this.plugin.getTaskManager().getTasksForPlayer(player.getUniqueId().toString());
                int maxPages = (int)Math.ceil((double)playerTasks.size() / 21.0);
                if (gui.getCurrentPage() >= maxPages - 1) break;
                gui.setCurrentPage(gui.getCurrentPage() + 1);
                gui.openMainMenu();
                break;
            }
            case 49: {
                player.closeInventory();
                gui.openNewTaskAnvil();
                break;
            }
            case 48: {
                gui.setCurrentPage(0);
                gui.openAllTasksMenu();
                break;
            }
            case 50: {
                gui.setCurrentPage(0);
                gui.openMyTasksMenu();
                break;
            }
            default: {
                if (event.getSlot() >= 21) break;
                this.handleTaskClick(event, player, gui);
            }
        }
    }

    private void handleAllTasksMenu(InventoryClickEvent event, Player player, TodoGUI gui) {
        switch (event.getSlot()) {
            case 45: {
                if (gui.getCurrentPage() <= 0) break;
                gui.setCurrentPage(gui.getCurrentPage() - 1);
                gui.openAllTasksMenu();
                break;
            }
            case 53: {
                List<Task> allTasks = this.plugin.getTaskManager().getAllTasks();
                int maxPages = (int)Math.ceil((double)allTasks.size() / 21.0);
                if (gui.getCurrentPage() >= maxPages - 1) break;
                gui.setCurrentPage(gui.getCurrentPage() + 1);
                gui.openAllTasksMenu();
                break;
            }
            case 49: {
                gui.setCurrentPage(0);
                gui.openMainMenu();
                break;
            }
            default: {
                if (event.getSlot() >= 21) break;
                this.handleTaskClick(event, player, gui);
            }
        }
    }

    private void handleMyTasksMenu(InventoryClickEvent event, Player player, TodoGUI gui) {
        switch (event.getSlot()) {
            case 45: {
                if (gui.getCurrentPage() <= 0) break;
                gui.setCurrentPage(gui.getCurrentPage() - 1);
                gui.openMyTasksMenu();
                break;
            }
            case 53: {
                List<Task> myTasks = this.plugin.getTaskManager().getTasksCreatedBy(player.getUniqueId().toString());
                int maxPages = (int)Math.ceil((double)myTasks.size() / 21.0);
                if (gui.getCurrentPage() >= maxPages - 1) break;
                gui.setCurrentPage(gui.getCurrentPage() + 1);
                gui.openMyTasksMenu();
                break;
            }
            case 49: {
                gui.setCurrentPage(0);
                gui.openMainMenu();
                break;
            }
            default: {
                if (event.getSlot() >= 21) break;
                this.handleTaskClick(event, player, gui);
            }
        }
    }

    private void handleAssignMenu(InventoryClickEvent event, Player player, TodoGUI gui, String title) {
        if (event.getSlot() == 49) {
            gui.openMainMenu();
            return;
        }
        if (event.getCurrentItem().getType() == Material.PLAYER_HEAD) {
            Player targetPlayer;
            SkullMeta meta = (SkullMeta)event.getCurrentItem().getItemMeta();
            String targetPlayerName = meta.getDisplayName().substring(2);
            String taskTitle = title.substring(title.indexOf(": ") + 2);
            Task targetTask = null;
            for (Task task : this.plugin.getTaskManager().getAllTasks()) {
                if (!task.getTitle().equals(taskTitle)) continue;
                targetTask = task;
                break;
            }
            if (targetTask != null && (targetPlayer = Bukkit.getPlayer((String)targetPlayerName)) != null) {
                targetTask.setAssignedTo(targetPlayer.getUniqueId().toString());
                this.plugin.getTaskManager().updateTask(targetTask);
                player.sendMessage("\u00a7a\u00a7lAufgabe zugewiesen! \u00a77'" + targetTask.getTitle() + "' wurde an " + targetPlayerName + " zugewiesen.");
                targetPlayer.sendMessage("\u00a7e\u00a7lNeue Aufgabe! \u00a77Du hast eine neue Aufgabe erhalten: '" + targetTask.getTitle() + "'");
                gui.openMainMenu();
            }
        }
    }

    private void handleTaskClick(InventoryClickEvent event, Player player, TodoGUI gui) {
        ItemStack item = event.getCurrentItem();
        String displayName = item.getItemMeta().getDisplayName();
        if (displayName.startsWith("\u00a76\u00a7l")) {
            String taskTitle = displayName.substring(4);
            Task targetTask = null;
            String inventoryTitle = event.getView().getTitle();
            List<Task> tasks = inventoryTitle.contains("Alle Aufgaben") ? this.plugin.getTaskManager().getAllTasks() : (inventoryTitle.contains("Meine erstellten") ? this.plugin.getTaskManager().getTasksCreatedBy(player.getUniqueId().toString()) : this.plugin.getTaskManager().getTasksForPlayer(player.getUniqueId().toString()));
            for (Task task : tasks) {
                if (!task.getTitle().equals(taskTitle)) continue;
                targetTask = task;
                break;
            }
            if (targetTask == null) {
                return;
            }
            if (event.getClick() == ClickType.LEFT) {
                targetTask.setCompleted(!targetTask.isCompleted());
                this.plugin.getTaskManager().updateTask(targetTask);
                String status = targetTask.isCompleted() ? "\u00a7aerledigt" : "\u00a7coffen";
                player.sendMessage("\u00a76\u00a7lStatus ge\u00e4ndert! \u00a77Aufgabe '" + targetTask.getTitle() + "' ist jetzt " + status + "\u00a77.");
                this.refreshCurrentView(event.getView().getTitle(), gui);
            } else if (event.getClick() == ClickType.RIGHT) {
                if (targetTask.getCreatedBy().equals(player.getUniqueId().toString()) || player.hasPermission("todo.admin")) {
                    this.plugin.getTaskManager().removeTask(targetTask.getId());
                    player.sendMessage("\u00a7c\u00a7lAufgabe gel\u00f6scht! \u00a77'" + targetTask.getTitle() + "' wurde entfernt.");
                    this.refreshCurrentView(event.getView().getTitle(), gui);
                } else {
                    player.sendMessage("\u00a7cDu kannst nur deine eigenen Aufgaben l\u00f6schen!");
                }
            } else if (event.getClick() == ClickType.SHIFT_LEFT) {
                if (targetTask.getCreatedBy().equals(player.getUniqueId().toString()) || player.hasPermission("todo.admin")) {
                    gui.openAssignMenu(targetTask.getId());
                } else {
                    player.sendMessage("\u00a7cDu kannst nur deine eigenen Aufgaben zuweisen!");
                }
            }
        }
    }

    private void refreshCurrentView(String title, TodoGUI gui) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (title.contains("Alle Aufgaben")) {
                gui.openAllTasksMenu();
            } else if (title.contains("Meine erstellten")) {
                gui.openMyTasksMenu();
            } else {
                gui.openMainMenu();
            }
        }, 1L);
    }
}

