/*
 * Decompiled with CFR 0.152.
 */
package de.todomc.managers;

import de.todomc.TodoPlugin;
import de.todomc.models.Task;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class TaskManager {
    private final TodoPlugin plugin;
    private final File tasksFile;
    private final Map<String, Task> tasks;
    private final Map<String, String> playerCreateModes;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public TaskManager(TodoPlugin plugin) {
        this.plugin = plugin;
        this.tasksFile = new File(plugin.getDataFolder(), "tasks.yml");
        this.tasks = new HashMap<String, Task>();
        this.playerCreateModes = new HashMap<String, String>();
    }

    public void loadTasks() {
        if (!this.tasksFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.tasksFile);
        ConfigurationSection tasksSection = config.getConfigurationSection("tasks");
        if (tasksSection == null) {
            return;
        }
        for (String taskId : tasksSection.getKeys(false)) {
            ConfigurationSection taskSection = tasksSection.getConfigurationSection(taskId);
            if (taskSection == null) continue;
            try {
                String title = taskSection.getString("title", "");
                String description = taskSection.getString("description", "");
                boolean completed = taskSection.getBoolean("completed", false);
                String assignedTo = taskSection.getString("assignedTo", "");
                String createdBy = taskSection.getString("createdBy", "");
                LocalDateTime createdAt = LocalDateTime.parse(taskSection.getString("createdAt"), this.formatter);
                LocalDateTime completedAt = null;
                String completedAtStr = taskSection.getString("completedAt");
                if (completedAtStr != null && !completedAtStr.isEmpty()) {
                    completedAt = LocalDateTime.parse(completedAtStr, this.formatter);
                }
                Task task = new Task(taskId, title, description, completed, assignedTo, createdBy, createdAt, completedAt);
                this.tasks.put(taskId, task);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Fehler beim Laden von Task " + taskId + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Es wurden " + this.tasks.size() + " Aufgaben geladen.");
    }

    public void saveTasks() {
        YamlConfiguration config = new YamlConfiguration();
        ConfigurationSection tasksSection = config.createSection("tasks");
        for (Task task : this.tasks.values()) {
            ConfigurationSection taskSection = tasksSection.createSection(task.getId());
            taskSection.set("title", (Object)task.getTitle());
            taskSection.set("description", (Object)task.getDescription());
            taskSection.set("completed", (Object)task.isCompleted());
            taskSection.set("assignedTo", (Object)task.getAssignedTo());
            taskSection.set("createdBy", (Object)task.getCreatedBy());
            taskSection.set("createdAt", (Object)task.getCreatedAt().format(this.formatter));
            if (task.getCompletedAt() == null) continue;
            taskSection.set("completedAt", (Object)task.getCompletedAt().format(this.formatter));
        }
        try {
            config.save(this.tasksFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Fehler beim Speichern der Aufgaben: " + e.getMessage());
        }
    }

    public void addTask(Task task) {
        this.tasks.put(task.getId(), task);
        this.saveTasks();
    }

    public void removeTask(String taskId) {
        this.tasks.remove(taskId);
        this.saveTasks();
    }

    public void updateTask(Task task) {
        this.tasks.put(task.getId(), task);
        this.saveTasks();
    }

    public Task getTask(String taskId) {
        return this.tasks.get(taskId);
    }

    public List<Task> getAllTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public List<Task> getTasksForPlayer(String playerUuid) {
        return this.tasks.values().stream().filter(task -> task.getAssignedTo().equals(playerUuid)).sorted((t1, t2) -> {
            if (t1.isCompleted() != t2.isCompleted()) {
                return Boolean.compare(t1.isCompleted(), t2.isCompleted());
            }
            return t2.getCreatedAt().compareTo(t1.getCreatedAt());
        }).collect(Collectors.toList());
    }

    public List<Task> getTasksCreatedBy(String playerUuid) {
        return this.tasks.values().stream().filter(task -> task.getCreatedBy().equals(playerUuid)).sorted((t1, t2) -> t2.getCreatedAt().compareTo(t1.getCreatedAt())).collect(Collectors.toList());
    }

    public void setPlayerInCreateMode(String playerUuid, String mode) {
        this.playerCreateModes.put(playerUuid, mode);
    }

    public String getPlayerCreateMode(String playerUuid) {
        return this.playerCreateModes.get(playerUuid);
    }

    public void removePlayerFromCreateMode(String playerUuid) {
        this.playerCreateModes.remove(playerUuid);
    }

    public boolean isPlayerInCreateMode(String playerUuid) {
        return this.playerCreateModes.containsKey(playerUuid);
    }
}

