package dev.ninjdai.letsdocompat;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public final class RecipeJsonUtil {
    public static final Map<String, List<class_3545<String, RecipeConvertor>>> RECIPE_CONVERSION_MAP = new HashMap<>();

    public static final RecipeConvertor generateFDCookingPotFromLDCookingPot = (ldRecipe) -> {
        JsonObject FDCookingPotRecipe = new JsonObject();
        FDCookingPotRecipe.add("type", new JsonPrimitive("farmersdelight:cooking"));
        FDCookingPotRecipe.add("recipe_book_tab", new JsonPrimitive("meals"));
        FDCookingPotRecipe.add("ingredients", ldRecipe.getAsJsonArray("ingredients"));
        if (ldRecipe.has("container") && ldRecipe.getAsJsonPrimitive("requireContainer").getAsBoolean()) {
            FDCookingPotRecipe.add("container", ldRecipe.get("container"));
        }
        FDCookingPotRecipe.add("result", ldRecipe.get("result"));

        return FDCookingPotRecipe;
    };

    @Nullable
    public static final RecipeConvertor generateLDCookingPotFromFDCookingPot = (fdRecipe) -> {
        JsonObject letsDoCookingPotRecipe = new JsonObject();
        letsDoCookingPotRecipe.add("type", new JsonPrimitive("farm_and_charm:pot_cooking"));
        letsDoCookingPotRecipe.add("ingredients", fdRecipe.getAsJsonArray("ingredients"));
        if (fdRecipe.has("container")) {
            letsDoCookingPotRecipe.add("requireContainer", new JsonPrimitive(true));
            letsDoCookingPotRecipe.add("container", fdRecipe.get("container"));
        } else {
            class_2960 resultLocation = class_2960.method_60654(fdRecipe.getAsJsonObject("result").get("id").getAsString());
            if (class_7923.field_41178.method_10250(resultLocation)) {
                class_1792 i = class_7923.field_41178.method_10223(resultLocation);
                if (i.method_7857()) {
                    letsDoCookingPotRecipe.add("requireContainer", new JsonPrimitive(true));
                    JsonObject container = new JsonObject();
                    container.add("count", new JsonPrimitive(1));
                    container.add("id", new JsonPrimitive(i.method_7858().toString()));
                    letsDoCookingPotRecipe.add("container", container);
                } else {
                    return null;
                }
            } else {
                Compat.LOGGER.info("FD Pot recipe for {} missing container", fdRecipe.get("result"));
                return null;
            }
        }
        letsDoCookingPotRecipe.add("result", fdRecipe.get("result"));
        letsDoCookingPotRecipe.add("requiresLearning", new JsonPrimitive(false));

        return letsDoCookingPotRecipe;
    };

    public static final RecipeConvertor generateCreateMixerFromFCBowl = (jsonRecipe) -> {
        JsonObject createMixerRecipe = new JsonObject();
        createMixerRecipe.add("type", new JsonPrimitive("create:mixing"));
        createMixerRecipe.add("ingredients", jsonRecipe.getAsJsonArray("ingredients"));

        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMixerRecipe.add("results", resultsArray);

        return createMixerRecipe;
    };

    public static final RecipeConvertor generateCreateMillingFromFDMincer = (jsonRecipe) -> {
        JsonObject createMillingRecipe = new JsonObject();
        createMillingRecipe.add("type", new JsonPrimitive("create:milling"));
        createMillingRecipe.add("processingTime", new JsonPrimitive(90));

        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add(jsonRecipe.get("ingredient"));
        createMillingRecipe.add("ingredients", ingredientsArray);

        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMillingRecipe.add("results", resultsArray);

        return createMillingRecipe;
    };

    static {
        RECIPE_CONVERSION_MAP.put("farm_and_charm:pot_cooking", List.of(
                new class_3545<>("farmersdelight", RecipeJsonUtil.generateFDCookingPotFromLDCookingPot)
        ));
        RECIPE_CONVERSION_MAP.put("farmersdelight:cooking", List.of(
                new class_3545<>("farm_and_charm", RecipeJsonUtil.generateLDCookingPotFromFDCookingPot)
        ));
        RECIPE_CONVERSION_MAP.put("farm_and_charm:crafting_bowl", List.of(
                new class_3545<>("create", RecipeJsonUtil.generateCreateMixerFromFCBowl)
        ));
    }

    public interface RecipeConvertor {
        JsonObject generate(JsonObject jsonRecipe);
    }
}