package dev.ninjdai.letsdocompat.mixin;

import com.google.gson.*;
import dev.ninjdai.letsdocompat.Compat;
import dev.ninjdai.letsdocompat.DoAddonExpectPlatform;
import dev.ninjdai.letsdocompat.RecipeJsonUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;

@Mixin(class_1863.class)
public abstract class RecipeManagerMixin {
    @Inject(method = "apply*", at = @At(value = "HEAD"))
    public void interceptApply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller, CallbackInfo info) {
        HashMap<class_2960, JsonElement> tMap = new HashMap<>();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 resourceLocation = entry.getKey();
            JsonObject jsonRecipe = entry.getValue().getAsJsonObject();
            if (!jsonRecipe.has("type")) continue;
            try {
                String recipeType = jsonRecipe.get("type").getAsString();
                if (RecipeJsonUtil.RECIPE_CONVERSION_MAP.containsKey(recipeType)) {
                    List<class_3545<String, RecipeJsonUtil.RecipeConvertor>> modConvertorTupleList = RecipeJsonUtil.RECIPE_CONVERSION_MAP.get(recipeType);
                    for (class_3545<String, RecipeJsonUtil.RecipeConvertor> modConvertorTuple: modConvertorTupleList) {
                        if (DoAddonExpectPlatform.isModLoaded(modConvertorTuple.method_15442())) {
                            JsonObject recipe = modConvertorTuple.method_15441().generate(jsonRecipe);
                            if (recipe==null) continue;

                            tMap.put(
                                //Example generated ResourceLocation: "letsdocompat:create/crafting_bowl/butter"
                                class_2960.method_60655(Compat.MOD_ID, modConvertorTuple.method_15442() + "/" + resourceLocation.method_12832()),
                                recipe
                            );
                        }
                    }
                }
            } catch (Exception e) {
                Compat.LOGGER.error("Errored when converting recipes", e);
            }
        }
        map.putAll(tMap);
        Compat.LOGGER.info("Added {} compatibility recipes !", tMap.size());
    }
}
