/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.letsdocompat.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ninjdai.letsdocompat.Compat;
import dev.ninjdai.letsdocompat.DoAddonExpectPlatform;
import dev.ninjdai.letsdocompat.RecipeJsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1863.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply*"}, at={@At(value="HEAD")})
    public void interceptApply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller, CallbackInfo info) {
        HashMap<class_2960, JsonObject> tMap = new HashMap<class_2960, JsonObject>();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 resourceLocation = entry.getKey();
            JsonObject jsonRecipe = entry.getValue().getAsJsonObject();
            if (!jsonRecipe.has("type")) continue;
            try {
                String recipeType = jsonRecipe.get("type").getAsString();
                if (!RecipeJsonUtil.RECIPE_CONVERSION_MAP.containsKey(recipeType)) continue;
                List<class_3545<String, RecipeJsonUtil.RecipeConvertor>> modConvertorTupleList = RecipeJsonUtil.RECIPE_CONVERSION_MAP.get(recipeType);
                for (class_3545<String, RecipeJsonUtil.RecipeConvertor> modConvertorTuple : modConvertorTupleList) {
                    JsonObject recipe;
                    if (!DoAddonExpectPlatform.isModLoaded((String)modConvertorTuple.method_15442()) || (recipe = ((RecipeJsonUtil.RecipeConvertor)modConvertorTuple.method_15441()).generate(jsonRecipe)) == null) continue;
                    tMap.put(class_2960.method_60655((String)"letsdocompat", (String)((String)modConvertorTuple.method_15442() + "/" + resourceLocation.method_12832())), recipe);
                }
            }
            catch (Exception e) {
                Compat.LOGGER.error("Errored when converting recipes", (Throwable)e);
            }
        }
        map.putAll(tMap);
        Compat.LOGGER.info("Added {} compatibility recipes !", (Object)tMap.size());
    }
}

