/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.soundsbegone.client;

import gg.meza.soundsbegone.SoundsBeGoneConfig;
import gg.meza.soundsbegone.client.SoundsBeGoneClient;
import gg.meza.supporters.clothconfig.SupportCategory;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen {
    public static Screen getConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"soundsbegone.config.title")).setSavingRunnable(() -> SoundsBeGoneClient.config.saveConfig());
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.translatable((String)"soundsbegone.config.category.latest"));
        ConfigCategory disabled = builder.getOrCreateCategory((Component)Component.translatable((String)"soundsbegone.config.category.disabled"));
        ConfigCategory settings = builder.getOrCreateCategory((Component)Component.translatable((String)"soundsbegone.config.category.settings"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        settings.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"soundsbegone.config.telemetry.switch"), SoundsBeGoneClient.config.isTelemetryEnabled()).setDefaultValue(SoundsBeGoneClient.config.isTelemetryEnabled()).setSaveConsumer(newValue -> SoundsBeGoneClient.config.toggleTelemetry((boolean)newValue)).build());
        settings.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.translatable((String)"soundsbegone.config.telemetry.description")).build());
        settings.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.translatable((String)"soundsbegone.config.telemetry.verify", (Object[])new Object[]{"https://github.com/meza/SoundsBeGone"})).build());
        SubCategoryBuilder telemetrySubcategory = entryBuilder.startSubCategory((Component)Component.translatable((String)"soundsbegone.config.telemetry.used"));
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.sound"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.version.mod"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.version.minecraft"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.version.java"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.loader"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.os"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.time"))).build());
        telemetrySubcategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.literal((String)"-").append((Component)Component.translatable((String)"soundsbegone.config.telemetry.data.language"))).build());
        settings.addEntry((AbstractConfigListEntry)telemetrySubcategory.build());
        settings.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.translatable((String)"soundsbegone.config.telemetry.disclaimer")).build());
        SoundsBeGoneClient.SoundMap.keySet().stream().filter(s -> !SoundsBeGoneClient.config.isSoundDisabled((String)s)).sorted().forEach(key -> general.addEntry(ConfigScreen.constructOption(entryBuilder, key)));
        SoundsBeGoneClient.config.disabledSounds().stream().sorted().forEach(key -> disabled.addEntry(ConfigScreen.constructOption(entryBuilder, key)));
        SupportCategory.add((ConfigBuilder)builder, (ConfigEntryBuilder)entryBuilder);
        return builder.build();
    }

    private static AbstractConfigListEntry<?> constructOption(ConfigEntryBuilder builder, String key) {
        return builder.startBooleanToggle((Component)Component.translatable((String)key), SoundsBeGoneClient.config.isSoundDisabled(key)).setDefaultValue(SoundsBeGoneClient.config.isSoundDisabled(key)).setSaveConsumer(newValue -> {
            if (newValue.booleanValue()) {
                if (!SoundsBeGoneClient.config.isSoundDisabled(key)) {
                    SoundsBeGoneConfig.LOGGER.info("Disabling sound: " + key);
                    SoundsBeGoneClient.config.disableSound(key);
                    SoundsBeGoneClient.telemetry.mutedSound(key);
                }
            } else if (SoundsBeGoneClient.config.isSoundDisabled(key)) {
                SoundsBeGoneConfig.LOGGER.info("Enabling sound: " + key);
                SoundsBeGoneClient.config.enableSound(key);
                SoundsBeGoneClient.telemetry.unmutedSound(key);
            }
        }).setYesNoTextSupplier(bool -> bool != false ? Component.translatable((String)"soundsbegone.enable") : Component.translatable((String)"soundsbegone.disable")).build();
    }
}

