/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.soundsbegone;

import gg.meza.soundsbegone.SoundsBeGoneConfig;
import gg.meza.soundsbegone.client.ConfigScreen;
import gg.meza.soundsbegone.client.SoundsBeGoneClient;
import gg.meza.soundsbegone.client.TranslationReminder;
import gg.meza.soundsbegone.client.neoforge.ConfigScreenFactory;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@Mod(value="soundsbegone")
public class SoundsBeGone {
    public SoundsBeGone(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)new ConfigScreenFactory());
        SoundsBeGoneConfig.LOGGER.info("SoundsBeGone initialized");
    }

    @EventBusSubscriber(modid="soundsbegone")
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            SoundsBeGoneClient.initClient();
        }

        @SubscribeEvent
        public static void keyBinds(RegisterKeyMappingsEvent event) {
            event.register(SoundsBeGoneClient.openConfig);
        }
    }

    @EventBusSubscriber(modid="soundsbegone")
    public static class GameModEvents {
        static int tickCounter = 0;

        @SubscribeEvent
        public static void shutdown(GameShuttingDownEvent event) {
            SoundsBeGoneClient.telemetry.flush();
        }

        @SubscribeEvent
        public static void logout(PlayerEvent.PlayerLoggedOutEvent event) {
            SoundsBeGoneClient.telemetry.flush();
        }

        @SubscribeEvent
        public static void endTick(ClientTickEvent.Post event) {
            if (SoundsBeGoneClient.openConfig.consumeClick()) {
                Minecraft.getInstance().setScreen(ConfigScreen.getConfigScreen(null));
            }
            if (tickCounter++ < 200) {
                return;
            }
            SoundsBeGoneClient.SoundMap.entrySet().removeIf(entry -> new Date().getTime() - ((Date)entry.getValue()).getTime() > 60000L);
            tickCounter = 0;
        }

        @SubscribeEvent
        public static void clientJoin(ClientPlayerNetworkEvent.LoggingIn event) {
            TranslationReminder.notify(Minecraft.getInstance());
        }
    }
}

