/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.soundsbegone.client.mixin;

import gg.meza.soundsbegone.SoundsBeGoneConfig;
import gg.meza.soundsbegone.client.SoundsBeGoneClient;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSoundInstance.class})
public class AbstractSoundInstanceMixin {
    @Final
    @Shadow
    protected ResourceLocation location;

    @Inject(method={"getVolume()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVolume(CallbackInfoReturnable<Float> cir) {
        if (SoundsBeGoneClient.config.isSoundDisabled(this.location.toString())) {
            SoundsBeGoneConfig.LOGGER.debug("Disabling the sound: {}", (Object)this.location);
            SoundsBeGoneClient.telemetry.blockedSound(this.location.toString());
            cir.setReturnValue((Object)Float.valueOf(0.0f));
            cir.cancel();
        }
        if (Minecraft.getInstance().level != null) {
            SoundsBeGoneClient.SoundMap.put(this.location.toString(), new Date());
        }
    }
}

