/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.soundsbegone.telemetry;

import com.posthog.java.PostHog;
import gg.meza.soundsbegone.SoundsBeGoneConfig;
import gg.meza.soundsbegone.client.SoundsBeGoneClient;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import org.apache.commons.codec.digest.DigestUtils;

public class Telemetry {
    private static final String POSTHOG_API_KEY = "";
    private static final String POSTHOG_HOST = "https://eu.posthog.com";
    private final PostHog posthog;
    private final Map<String, Integer> blockedSoundsCount = new ConcurrentHashMap<String, Integer>();
    private final String uuid = DigestUtils.sha256Hex((String)Minecraft.getInstance().getUser().getName());
    private final String OS_NAME = System.getProperty("os.name");
    private final String MC_VERSION = "1.21.6";
    private final String JAVA_VERSION = System.getProperty("java.version");
    private final String LOADER = "neoforge";
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final Minecraft client;

    public Telemetry(Minecraft client) {
        this.client = client;
        this.posthog = new PostHog.Builder(POSTHOG_API_KEY).host(POSTHOG_HOST).build();
        if (SoundsBeGoneClient.config.isTelemetryEnabled()) {
            this.scheduler.scheduleAtFixedRate(this::sendBlockedData, 30L, 30L, TimeUnit.MINUTES);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private void sendEvent(String event, String sound) {
        this.sendEvent(event, sound, Map.of());
    }

    private void sendEvent(String event, String sound, Map<String, Object> extraProps) {
        if (!SoundsBeGoneClient.config.isTelemetryEnabled()) {
            return;
        }
        String languageCode = this.client.getLanguageManager().getSelected().toLowerCase();
        ConcurrentHashMap<String, String> baseProps = new ConcurrentHashMap<String, String>(Map.of("sound", sound, "Minecraft Version", "1.21.6", "OS", this.OS_NAME, "Local Time", new Date().toString(), "ModVersion", "1.4.9", "Java Version", this.JAVA_VERSION, "Loader", "neoforge", "Language", languageCode));
        baseProps.putAll(extraProps);
        this.posthog.capture(this.uuid, event, baseProps);
    }

    public void mutedSound(String sound) {
        this.sendEvent("Muted Sound", sound);
    }

    public void blockedSound(String sound) {
        if (this.blockedSoundsCount.containsKey(sound)) {
            this.blockedSoundsCount.put(sound, this.blockedSoundsCount.get(sound) + 1);
        } else {
            this.blockedSoundsCount.put(sound, 1);
        }
        if (this.blockedSoundsCount.get(sound) > 2147482647) {
            this.sendEvent("Blocked Sound", sound, Map.of("count", this.blockedSoundsCount.get(sound)));
            this.blockedSoundsCount.remove(sound);
        }
    }

    public void unmutedSound(String sound) {
        this.sendEvent("UnMuted Sound", sound);
    }

    public void sendBlockedData() {
        HashMap<String, Integer> soundsToSend = new HashMap<String, Integer>(this.blockedSoundsCount);
        this.blockedSoundsCount.clear();
        soundsToSend.forEach((sound, count) -> this.sendEvent("Blocked Sound", (String)sound, Map.of("count", count)));
    }

    public void flush() {
        SoundsBeGoneConfig.LOGGER.debug("Flushing telemetry");
        this.sendBlockedData();
    }

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void startMinecraft() {
        this.sendEvent("Started Minecraft", POSTHOG_API_KEY);
    }
}

