/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.soundsbegone;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import gg.meza.soundsbegone.ConfigData;
import gg.meza.soundsbegone.SoundsBeGoneConfig;
import gg.meza.soundsbegone.client.ConfigPathResolver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.lang3.SerializationException;

public class Config {
    private ConfigData configData = new ConfigData();
    private final Path oldConfigPath = ConfigPathResolver.getConfigDir("disabled_sounds.json");
    private final Path configPath = ConfigPathResolver.getConfigDir("soundsbegone.json");
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public String lastVersionSeen() {
        return this.configData.lastVersionSeen;
    }

    public void setLastVersionSeen(String version) {
        this.configData.lastVersionSeen = version;
        this.saveConfig();
    }

    public boolean isTelemetryEnabled() {
        return this.configData.telemetry;
    }

    public void toggleTelemetry(boolean toValue) {
        this.configData.telemetry = toValue;
    }

    public void disableSound(String sound) {
        this.configData.sounds.add(sound);
    }

    public void enableSound(String sound) {
        this.configData.sounds.remove(sound);
    }

    public boolean isSoundDisabled(String sound) {
        return this.configData.sounds.contains(sound);
    }

    public Set<String> disabledSounds() {
        return this.configData.sounds;
    }

    public void initConfig() {
        this.renameConfigFile();
        if (Files.exists(this.configPath, new LinkOption[0])) {
            try {
                BufferedReader reader = Files.newBufferedReader(this.configPath);
                this.configData = (ConfigData)this.GSON.fromJson((Reader)reader, ConfigData.class);
                reader.close();
            }
            catch (JsonParseException | IOException e) {
                SoundsBeGoneConfig.LOGGER.error("Cause: " + e.getCause().getClass().getSimpleName());
                if (e.getCause().getClass() == IllegalStateException.class) {
                    this.convertConfig(this.configPath);
                    return;
                }
                throw new SerializationException(e);
            }
        }
    }

    public void saveConfig() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);
            this.GSON.toJson((Object)this.configData, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private void renameConfigFile() {
        try {
            if (Files.exists(this.oldConfigPath, new LinkOption[0])) {
                if (Files.exists(this.configPath, new LinkOption[0])) {
                    SoundsBeGoneConfig.LOGGER.warn("Old config file found, but new config file already exists. Please delete the old config file manually.");
                    return;
                }
                Files.move(this.oldConfigPath, this.configPath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private void convertConfig(Path configPath) {
        try {
            SoundsBeGoneConfig.LOGGER.warn("Old config file found, migrating to new format");
            BufferedReader reader = Files.newBufferedReader(configPath);
            Type setType = new TypeToken<Set<String>>(){}.getType();
            Set disabledSounds = (Set)this.GSON.fromJson((Reader)reader, setType);
            reader.close();
            this.configData.sounds = disabledSounds;
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.GSON.toJson((Object)this.configData, (Appendable)writer);
            writer.close();
        }
        catch (JsonParseException | IOException e) {
            throw new SerializationException(e);
        }
    }
}

