/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class AstralArrow
extends AbstractArrow {
    private int ricochetCount = 3;

    public AstralArrow(EntityType<? extends AstralArrow> entityType, Level level) {
        super(entityType, level);
    }

    public AstralArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.ASTRAL_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(7.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.hurt(this.damageSources().arrow((AbstractArrow)this, this.getOwner()), (float)this.getBaseDamage());
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide()) {
            int maxRicochets = 6;
            if (this.ricochetCount < maxRicochets) {
                ++this.ricochetCount;
                Vec3 velocity = this.getDeltaMovement();
                Vec3 normal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal());
                Vec3 reflected = velocity.subtract(normal.scale(2.0 * velocity.dot(normal)));
                this.setDeltaMovement(reflected.scale(0.7));
                Vec3 positionOffset = reflected.normalize().scale(0.1);
                this.setPos(this.getX() + positionOffset.x, this.getY() + positionOffset.y, this.getZ() + positionOffset.z);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.METAL_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                this.discard();
            }
        }
    }

    public void tick() {
        super.tick();
        Vec3 movement = this.getDeltaMovement();
        if (movement.lengthSqr() < 0.01) {
            this.discard();
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

