/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EtherealArrow
extends AbstractArrow {
    private boolean hasHit = false;
    private int hitTimer = 0;
    private final int maxHitDuration = 40;

    public EtherealArrow(EntityType<? extends EtherealArrow> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(false);
    }

    public EtherealArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.ETHEREAL_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setNoGravity(false);
    }

    public void tick() {
        super.tick();
        if (this.hasHit) {
            ++this.hitTimer;
            if (this.hitTimer >= 40) {
                this.discard();
                return;
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            Entity entity = result.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
            }
            this.hasHit = true;
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.hasHit = true;
        }
    }

    protected boolean tryPickup(Player player) {
        return false;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }
}

