/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.bandit.many_bows.util.AncientSageDamageSource;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class RadiantArrow
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private boolean hasExploded = false;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public RadiantArrow(EntityType<? extends RadiantArrow> entityType, Level level) {
        super(entityType, level);
    }

    public RadiantArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.RADIANT_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!(this.hasExploded || result.getType() != HitResult.Type.BLOCK && result.getType() != HitResult.Type.ENTITY)) {
            this.hasExploded = true;
            this.createRadiantExplosion(this.level(), this);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
    }

    private void createRadiantExplosion(Level level, RadiantArrow arrow) {
        AttributeInstance attrInstance;
        Registry registry;
        Holder.Reference rangedAttrHolder;
        LivingEntity livingShooter;
        LivingEntity shooter;
        level.explode(null, arrow.getX(), arrow.getY(), arrow.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
        AABB explosionArea = new AABB(arrow.getX() - 5.0, arrow.getY() - 5.0, arrow.getZ() - 5.0, arrow.getX() + 5.0, arrow.getY() + 5.0, arrow.getZ() + 5.0);
        Entity entity2 = arrow.getOwner();
        LivingEntity livingEntity = shooter = entity2 instanceof LivingEntity ? (livingShooter = (LivingEntity)entity2) : null;
        float scaledDamage = shooter != null ? ((rangedAttrHolder = (Holder.Reference)(registry = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE)).getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null)) != null ? ((attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null ? (float)attrInstance.getValue() / 2.0f : 3.0f) : 3.0f) : 3.0f;
        level.getEntitiesOfClass(LivingEntity.class, explosionArea).forEach(entity -> {
            if (entity == shooter || shooter != null && entity.isAlliedTo((Entity)shooter)) {
                return;
            }
            float damage = entity.isInvertedHealAndHarm() ? scaledDamage * 2.0f * this.powerMultiplier : scaledDamage * this.powerMultiplier;
            entity.hurt(AncientSageDamageSource.createRadiantDamage(level, (Entity)arrow), damage);
        });
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

