/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.mixin;

import net.bandit.many_bows.registry.EffectRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityWaterExtinguishMixin {
    @Unique
    private static final ResourceKey<MobEffect> TMB_CURSED_KEY = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)EffectRegistry.CURSED_FLAME.getId());

    @Unique
    private static boolean tmb$hasCursedByKey(Entity e) {
        if (!(e instanceof LivingEntity)) {
            return false;
        }
        LivingEntity le = (LivingEntity)e;
        for (MobEffectInstance inst : le.getActiveEffects()) {
            if (!inst.getEffect().is(TMB_CURSED_KEY)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"updateInWaterStateAndDoWaterCurrentPushing()V"}, at={@At(value="TAIL")})
    private void tmb$afterWaterCurrentPushing(CallbackInfo ci) {
        LivingEntity le;
        Entity e = (Entity)this;
        if (EntityWaterExtinguishMixin.tmb$hasCursedByKey(e) && (le = (LivingEntity)e).getRemainingFireTicks() < 20) {
            le.setRemainingFireTicks(20);
        }
    }

    @Inject(method={"updateInWaterStateAndDoFluidPushing()Z"}, at={@At(value="TAIL")})
    private void tmb$afterFluidPushing(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity le;
        Entity e = (Entity)this;
        if (EntityWaterExtinguishMixin.tmb$hasCursedByKey(e) && (le = (LivingEntity)e).getRemainingFireTicks() < 20) {
            le.setRemainingFireTicks(20);
        }
    }
}

