/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;

public class HunterArrow
extends AbstractArrow {
    public HunterArrow(EntityType<? extends HunterArrow> entityType, Level level) {
        super(entityType, level);
    }

    public HunterArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.HUNTER_ARROW.get(), shooter, level);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!this.m_9236_().f_46443_ && this.isPassiveMob(target) && this.m_19749_() instanceof Player && (!target.m_6084_() || target.m_21224_())) {
            this.improveDrops(target);
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    private boolean isPassiveMob(LivingEntity entity) {
        EntityType t = entity.m_6095_();
        return t == EntityType.f_20557_ || t == EntityType.f_20510_ || t == EntityType.f_20520_ || t == EntityType.f_20555_ || t == EntityType.f_20517_;
    }

    private void improveDrops(LivingEntity entity) {
        RandomSource rng = this.m_9236_().f_46441_;
        boolean cooked = entity.m_6060_();
        if (entity instanceof Cow) {
            int beef = 1 + rng.m_188503_(3);
            int leather = rng.m_188503_(2);
            entity.m_19983_(new ItemStack((ItemLike)(cooked ? Items.f_42580_ : Items.f_42579_), beef));
            if (leather > 0) {
                entity.m_19983_(new ItemStack((ItemLike)Items.f_42454_, leather));
            }
        } else if (entity instanceof Pig) {
            int pork = 1 + rng.m_188503_(3);
            entity.m_19983_(new ItemStack((ItemLike)(cooked ? Items.f_42486_ : Items.f_42485_), pork));
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            int mutton = 1 + rng.m_188503_(3);
            entity.m_19983_(new ItemStack((ItemLike)(cooked ? Items.f_42659_ : Items.f_42658_), mutton));
            if (!sheep.m_29875_()) {
                entity.m_19983_(new ItemStack((ItemLike)this.woolFor(sheep.m_29874_())));
            }
        } else if (entity instanceof Chicken) {
            int meat = 1;
            int feathers = rng.m_188503_(3);
            entity.m_19983_(new ItemStack((ItemLike)(cooked ? Items.f_42582_ : Items.f_42581_), meat));
            if (feathers > 0) {
                entity.m_19983_(new ItemStack((ItemLike)Items.f_42402_, feathers));
            }
        } else if (entity instanceof Rabbit) {
            int meat = 1 + rng.m_188503_(2);
            int hide = rng.m_188503_(2);
            entity.m_19983_(new ItemStack((ItemLike)(cooked ? Items.f_42698_ : Items.f_42697_), meat));
            if (hide > 0) {
                entity.m_19983_(new ItemStack((ItemLike)Items.f_42649_, hide));
            }
            if (rng.m_188501_() < 0.1f) {
                entity.m_19983_(new ItemStack((ItemLike)Items.f_42648_));
            }
        }
    }

    private Block woolFor(DyeColor color) {
        switch (color) {
            case WHITE: {
                return Blocks.f_50041_;
            }
            case ORANGE: {
                return Blocks.f_50042_;
            }
            case MAGENTA: {
                return Blocks.f_50096_;
            }
            case LIGHT_BLUE: {
                return Blocks.f_50097_;
            }
            case YELLOW: {
                return Blocks.f_50098_;
            }
            case LIME: {
                return Blocks.f_50099_;
            }
            case PINK: {
                return Blocks.f_50100_;
            }
            case GRAY: {
                return Blocks.f_50101_;
            }
            case LIGHT_GRAY: {
                return Blocks.f_50102_;
            }
            case CYAN: {
                return Blocks.f_50103_;
            }
            case PURPLE: {
                return Blocks.f_50104_;
            }
            case BLUE: {
                return Blocks.f_50105_;
            }
            case BROWN: {
                return Blocks.f_50106_;
            }
            case GREEN: {
                return Blocks.f_50107_;
            }
            case RED: {
                return Blocks.f_50108_;
            }
            case BLACK: {
                return Blocks.f_50109_;
            }
        }
        return Blocks.f_50041_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

