/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class TorchbearerArrow
extends AbstractArrow {
    public TorchbearerArrow(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public TorchbearerArrow(Level level, LivingEntity shooter) {
        super(EntityType.f_20548_, shooter, level);
        this.m_36781_(5.0);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        boolean shouldDiscard = false;
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            Entity entity = entityHitResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_20254_(5);
                shouldDiscard = true;
            }
        } else if (result instanceof BlockHitResult) {
            Level level;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            BlockPos hitPos = blockHitResult.m_82425_();
            Direction hitFace = blockHitResult.m_82434_();
            BlockPos placePos = hitPos.m_121945_(hitFace);
            if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (hitFace == Direction.UP) {
                    torchPos = hitPos.m_7494_();
                    BlockState torchState = Blocks.f_50081_.m_49966_();
                    if (torchState.m_60710_((LevelReader)serverLevel, torchPos)) {
                        serverLevel.m_7731_(torchPos, torchState, 3);
                        shouldDiscard = true;
                    }
                } else if (hitFace != Direction.DOWN) {
                    torchPos = hitPos.m_121945_(hitFace);
                    BlockState hitBlockState = serverLevel.m_8055_(hitPos);
                    boolean isFaceSturdy = hitBlockState.m_60783_((BlockGetter)serverLevel, hitPos, hitFace);
                    if (isFaceSturdy && serverLevel.m_8055_(torchPos).m_60795_()) {
                        BlockState wallTorchState = (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)hitFace);
                        serverLevel.m_7731_(torchPos, wallTorchState, 3);
                        shouldDiscard = true;
                    }
                }
            }
        }
        if (shouldDiscard) {
            this.m_146870_();
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

