/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.config.BowLootConfig;
import net.bandit.many_bows.config.ManyBowsConfigHolder;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrimsonNexusBow
extends BowItem {
    public CrimsonNexusBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            if (!level.f_46443_ && (power = CrimsonNexusBow.m_40661_((int)(charge = this.m_8105_(stack) - timeCharged))) >= 0.1f) {
                ArrowItem arrowItem;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11859_, SoundSource.PLAYERS, 1.0f, 1.5f);
                float healthCost = player.m_21223_() <= 4.0f ? 0.0f : 2.0f;
                player.m_6469_(player.m_269291_().m_269425_(), healthCost);
                ItemStack arrowStack = player.m_6298_(stack);
                if (arrowStack.m_41619_() || !(arrowStack.m_41720_() instanceof ArrowItem)) {
                    arrowItem = (ArrowItem)Items.f_42412_;
                    arrowStack = new ItemStack((ItemLike)Items.f_42412_);
                } else {
                    arrowItem = (ArrowItem)arrowStack.m_41720_();
                }
                AbstractArrow arrow = arrowItem.m_6394_(level, arrowStack, (LivingEntity)player);
                arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
                this.applyEnchantments(stack, arrow);
                if (player.m_21223_() == player.m_21233_()) {
                    arrow.m_36762_(true);
                    arrow.m_20254_(200);
                }
                level.m_7967_((Entity)arrow);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_150110_().f_35937_ || player.m_6298_(stack).m_41619_() || this.m_6437_().test(player.m_6298_(stack))) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private void applyEnchantments(ItemStack stack, AbstractArrow arrow) {
        int punchLevel;
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 1.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    private ItemStack findArrowInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (selected && !level.f_46443_ && level.m_46467_() % 20L == 0L && player.m_21223_() < player.m_21233_()) {
                AABB area = new AABB(player.m_20185_() - 8.0, player.m_20186_() - 4.0, player.m_20189_() - 8.0, player.m_20185_() + 8.0, player.m_20186_() + 4.0, player.m_20189_() + 8.0);
                List nearby = level.m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_() && !(e instanceof Player));
                BowLootConfig config = ManyBowsConfigHolder.CONFIG;
                nearby.removeIf(target -> {
                    String id = target.m_6095_().m_204041_().m_205785_().m_135782_().toString();
                    return config.emeraldSageCrimsonNexusBlacklist.contains(id);
                });
                if (!nearby.isEmpty()) {
                    LivingEntity target2 = (LivingEntity)nearby.get(level.f_46441_.m_188503_(nearby.size()));
                    target2.m_6469_(player.m_269291_().m_269425_(), 2.0f);
                    player.m_5634_(1.0f);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 0.3f, 1.5f);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                }
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_41720_() instanceof ArrowItem;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.crimson_nexus.tooltip.info").m_130940_(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.m_237110_((String)"item.many_bows.crimson_nexus.tooltip.health_cost", (Object[])new Object[]{"2.0"}).m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.crimson_nexus.tooltip.legend").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.shulker_blast_bow.hold_shift"));
        }
    }
}

