/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.WebstringArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class WebstringVolleyBow
extends class_1753 {
    private static final int ARROWS_TO_FIRE = 5;

    public WebstringVolleyBow(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7840(class_1799 bowStack, class_1937 level, class_1309 entity, int chargeTime) {
        if (entity instanceof class_1657) {
            int charge;
            float power;
            class_1657 player = (class_1657)entity;
            List projectiles = WebstringVolleyBow.method_57390((class_1799)bowStack, (class_1799)player.method_18808(bowStack), (class_1309)player);
            boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
            if ((!projectiles.isEmpty() || hasInfinity || player.method_31549().field_7477) && (power = WebstringVolleyBow.method_7722((int)(charge = this.method_7881(bowStack, entity) - chargeTime))) >= 0.1f) {
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    this.fireMultiArrows(serverLevel, player, bowStack, projectiles, power, level);
                }
                level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f);
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                if (!player.method_31549().field_7477) {
                    bowStack.method_7970(1, (class_1309)player, class_1304.field_6173);
                }
            }
        }
    }

    private void fireMultiArrows(class_3218 serverLevel, class_1657 player, class_1799 bowStack, List<class_1799> projectileStacks, float power, class_1937 level) {
        float basePitch = player.method_36455();
        float baseYaw = player.method_36454();
        float spreadAngle = 8.0f;
        if (projectileStacks.isEmpty() && !player.method_31549().field_7477) {
            return;
        }
        class_1799 projectileStack = projectileStacks.get(0);
        boolean arrowConsumed = false;
        boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
        for (int i = -2; i <= 2; ++i) {
            WebstringArrow arrow = new WebstringArrow((class_1937)serverLevel, (class_1309)player, bowStack, projectileStack);
            if (arrow instanceof WebstringArrow) {
                class_1324 attrInstance;
                WebstringArrow webstringArrow = arrow;
                class_6880 rangedDamageAttr = level.method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage")).orElse(null);
                if (rangedDamageAttr != null && (attrInstance = player.method_5996(rangedDamageAttr)) != null) {
                    float damage = (float)attrInstance.method_6194();
                    webstringArrow.method_7438(damage / 6.0f);
                }
            }
            this.applyPowerEnchantment(arrow, bowStack, level);
            this.applyKnockbackEnchantment(arrow, bowStack, (class_1309)player, level);
            this.applyFlameEnchantment(arrow, bowStack, level);
            float spreadOffset = (float)i * spreadAngle;
            arrow.method_24919((class_1297)player, basePitch, baseYaw + spreadOffset, 0.0f, power * 2.5f, 1.0f);
            arrow.field_7572 = i == 0 || hasInfinity ? class_1665.class_1666.field_7593 : class_1665.class_1666.field_7594;
            serverLevel.method_8649((class_1297)arrow);
        }
        if (!(hasInfinity || player.method_31549().field_7477 || arrowConsumed)) {
            projectileStack.method_7934(1);
            arrowConsumed = true;
        }
    }

    private void applyFlameEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> flame = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9126);
        int flameLevel = class_1890.method_8225(flame, (class_1799)bow);
        if (flameLevel > 0) {
            arrow.method_5639(5.0f);
        }
    }

    private void applyKnockbackEnchantment(class_1665 arrow, class_1799 bow, class_1309 shooter, class_1937 level) {
        class_6880<class_1887> punch = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9116);
        int punchLevel = class_1890.method_8225(punch, (class_1799)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.method_45325(class_5134.field_23718));
            class_243 knockbackVec = arrow.method_18798().method_1029().method_1021((double)punchLevel * 0.6 * resistance);
            arrow.method_5762(knockbackVec.field_1352, 0.1, knockbackVec.field_1350);
        }
    }

    private void applyPowerEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> power = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9103);
        int powerLevel = class_1890.method_8225(power, (class_1799)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.method_7438(arrow.method_7448() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(class_1799 bow, class_1937 level) {
        class_6880<class_1887> infinity = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9125);
        return class_1890.method_8225(infinity, (class_1799)bow) > 0;
    }

    private class_6880<class_1887> getEnchantmentHolder(class_1937 level, class_5321<class_1887> enchantmentKey) {
        return level.method_30349().method_30530(class_7924.field_41265).method_40290(enchantmentKey);
    }

    public Predicate<class_1799> method_19268() {
        return field_18281;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 16;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 bowStack = player.method_5998(hand);
        boolean hasArrows = !player.method_18808(bowStack).method_7960();
        boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
        if (!(hasArrows || hasInfinity || player.method_31549().field_7477)) {
            return class_1271.method_22431((Object)bowStack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)bowStack);
    }

    public int method_24792() {
        return 64;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_31574((class_1792)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if (class_437.method_25442()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.webstring_volley.details").method_27692(class_124.field_1054));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.webstring_volley").method_27692(class_124.field_1065));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.webstring_volley.tooltip").method_27692(class_124.field_1060));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.hold_shift").method_27692(class_124.field_1080));
        }
    }
}

