/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrSellChests.util.ColorSystem;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor {
    private final MrSellChests plugin;
    private FileConfiguration config;
    private FileConfiguration messages;

    public Commands(MrSellChests plugin) {
        this.plugin = plugin;
        this.reloadConfigs();
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.plugin.reloadMessages();
        this.config = this.plugin.getConfig();
        this.messages = this.plugin.getMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("unknown_subcommand", "&7/msc <give|reload|boost>")));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("mrsellchests.reload")) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("no_permission")));
                return true;
            }
            this.reloadConfigs();
            sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("reload_success")));
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            int amount;
            if (!sender.hasPermission("mrsellchests.give")) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("no_permission")));
                return true;
            }
            if (args.length < 4) {
                sender.sendMessage(ColorSystem.colorize(this.messages.getString("give_usage", "&cUsage: /msc give <player> <chest> <amount>")));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("give_player_not_found")));
                return true;
            }
            String chestType = args[2];
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException var9) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("give_invalid_amount")));
                return true;
            }
            if (!this.config.isConfigurationSection("SellChests." + chestType)) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("give_chest_type_not_found")));
                return true;
            }
            ItemStack item = this.createSellChestItem(chestType, amount);
            HashMap leftovers = target.getInventory().addItem(new ItemStack[]{item});
            if (!leftovers.isEmpty()) {
                for (Object obj : leftovers.values()) {
                    ItemStack left = (ItemStack)obj;
                    target.getWorld().dropItemNaturally(target.getLocation(), left);
                }
            }
            String msg = this.plugin.getMessage("give_success").replace("{amount}", String.valueOf(amount)).replace("{chest}", chestType).replace("{player}", target.getName());
            sender.sendMessage(ColorSystem.colorize(msg));
            return true;
        }
        if (args[0].equalsIgnoreCase("boost")) {
            long duration;
            double boost;
            if (!sender.hasPermission("mrsellchests.boost")) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("no_permission")));
                return true;
            }
            if (args.length >= 2 && args[1].equalsIgnoreCase("give")) {
                HashMap leftovers;
                ItemStack voucher;
                ItemMeta meta;
                int amount;
                if (args.length < 5) {
                    sender.sendMessage(ColorSystem.colorize(this.messages.getString("booster_give_usage")));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("boost_player_not_found")));
                    return true;
                }
                String boosterId = args[3];
                try {
                    amount = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("booster_invalid_amount")));
                    return true;
                }
                File boostersFile = new File(this.plugin.getDataFolder(), "boosters.yml");
                if (!boostersFile.exists()) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("boosters_yml_not_found")));
                    return true;
                }
                YamlConfiguration boosters = YamlConfiguration.loadConfiguration((File)boostersFile);
                if (!boosters.isConfigurationSection("Boosters." + boosterId)) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("booster_not_found")));
                    return true;
                }
                ConfigurationSection booster = boosters.getConfigurationSection("Boosters." + boosterId);
                ConfigurationSection headSection = booster.getConfigurationSection("Head");
                ConfigurationSection itemSection = booster.getConfigurationSection("Item");
                if (itemSection == null) {
                    sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("booster_item_not_defined")));
                    return true;
                }
                String matName = itemSection.getString("Material", "PAPER");
                Material mat = Material.matchMaterial((String)matName);
                if (mat == null) {
                    mat = Material.PAPER;
                }
                if ((meta = (voucher = new ItemStack(mat, amount)).getItemMeta()) != null) {
                    if (itemSection.contains("CustomModelData") && !"NONE".equalsIgnoreCase(itemSection.getString("CustomModelData"))) {
                        try {
                            meta.setCustomModelData(Integer.valueOf(Integer.parseInt(itemSection.getString("CustomModelData"))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    meta.setDisplayName(ColorSystem.colorize(itemSection.getString("Name", "&aBooster Voucher")));
                    List lore = itemSection.getStringList("Lore");
                    if (!lore.isEmpty()) {
                        for (int i = 0; i < lore.size(); ++i) {
                            lore.set(i, ColorSystem.colorize((String)lore.get(i)));
                        }
                        meta.setLore(lore);
                    }
                    if (itemSection.getBoolean("Glowing", false)) {
                        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    }
                    NamespacedKey boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_voucher");
                    meta.getPersistentDataContainer().set(boosterKey, PersistentDataType.STRING, (Object)boosterId);
                    boolean stackable = headSection != null && headSection.getBoolean("Stackable", false);
                    NamespacedKey stackableKey = new NamespacedKey((Plugin)this.plugin, "booster_stackable");
                    meta.getPersistentDataContainer().set(stackableKey, PersistentDataType.INTEGER, (Object)(stackable ? 1 : 0));
                    voucher.setItemMeta(meta);
                }
                if (!(leftovers = target.getInventory().addItem(new ItemStack[]{voucher})).isEmpty()) {
                    for (Object obj : leftovers.values()) {
                        ItemStack left = (ItemStack)obj;
                        target.getWorld().dropItemNaturally(target.getLocation(), left);
                    }
                }
                String msg = this.plugin.getMessage("booster_give_success").replace("{amount}", String.valueOf(amount)).replace("{booster}", boosterId).replace("{player}", target.getName());
                sender.sendMessage(ColorSystem.colorize(msg));
                return true;
            }
            if (args.length < 4) {
                sender.sendMessage(ColorSystem.colorize(this.messages.getString("boost_usage")));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("boost_player_not_found")));
                return true;
            }
            try {
                boost = Double.parseDouble(args[2]);
                duration = Long.parseLong(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("boost_invalid")));
                return true;
            }
            long until = System.currentTimeMillis() + duration * 1000L;
            File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            String playerPath = "players." + String.valueOf(target.getUniqueId()) + ".boost_temp";
            data.set(playerPath + ".value", (Object)boost);
            data.set(playerPath + ".until", (Object)until);
            try {
                data.save(dataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String msg = this.plugin.getMessage("boost_set").replace("{boost}", String.valueOf(boost)).replace("{duration}", String.valueOf(duration)).replace("{count}", "all").replace("{player}", target.getName());
            sender.sendMessage(msg);
            if (target.isOnline()) {
                String msg2 = this.plugin.getMessage("boost_received").replace("{boost}", String.valueOf(boost)).replace("{duration}", String.valueOf(duration));
                target.sendMessage(msg2);
            }
            return true;
        }
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessage("unknown_subcommand", "&cUnknown subcommand!")));
        return true;
    }

    private ItemStack createSellChestItem(String chestType, int amount) {
        ItemStack item;
        ItemMeta meta;
        String path = "SellChests." + chestType + ".Item.";
        String materialName = this.config.getString("SellChests." + chestType + ".Chest.Material", "CHEST");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.CHEST;
        }
        if ((meta = (item = new ItemStack(material, amount)).getItemMeta()) != null) {
            meta.setDisplayName(ColorSystem.colorize(this.config.getString(path + "Name", "Sell Chest")));
            List lore = this.config.getStringList(path + "Lore");
            if (!lore.isEmpty()) {
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ColorSystem.colorize((String)lore.get(i)));
                }
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "sellchest_type");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)chestType);
            item.setItemMeta(meta);
        }
        return item;
    }
}

