/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrSellChests.util.ColorSystem;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Messages {
    private final MrSellChests plugin;
    private FileConfiguration messages;

    public Messages(MrSellChests plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put("prefix", "&8[&aMrSellChests&8]");
        defaults.put("chest_created", "&aSell chest has been successfully created!");
        defaults.put("no_permission", "&cYou do not have permission to do this!");
        defaults.put("hologram_disabled", "&eHolograms are disabled in the configuration!");
        defaults.put("hologram_failed", "&cHologram could not be created! Unknown provider.");
        defaults.put("trasher_mode_changed", "&aTrasher mode changed to: &f{mode}");
        defaults.put("chest_link_success", "&aSuccessfully linked chest! ({current}/{max} linked)");
        defaults.put("chest_link_cancelled", "&cLinking mode cancelled!");
        defaults.put("chest_unlink_all", "&aAll linked chests have been removed!");
        defaults.put("chest_link_max", "&cMaximum number of linked chests reached ({current}/{max})");
        defaults.put("chest_link_max_disabled", "&cThis chest already has the maximum number of links ({max})");
        defaults.put("chest_link_invalid", "&cYou can only link storage containers like chests!");
        defaults.put("chest_link_start", "&aClick on a chest to link it! ({current}/{max} linked)");
        defaults.put("no_chest_access", "&cThis is not your chest!");
        defaults.put("chest_link_sell_chest", "&cYou cannot link a sell chest to another sell chest!");
        defaults.put("chest_same_chunk", "&cYou cannot place multiple sell chests in the same chunk!");
        defaults.put("no_chest_destroy", "&cThis is not your chest!");
        defaults.put("chest_destroyed", "&aYou have successfully broken and received your sell chest!");
        defaults.put("no_permission_place", "&cYou don't have permission to place this type of sell chest!");
        defaults.put("chest_limit_reached", "&cYou have reached your limit of {limit} sell chests!");
        defaults.put("state_enabled", "&aEnabled");
        defaults.put("state_disabled", "&cDisabled");
        defaults.put("boost_set", "&aSet temporary boost {boost}x for {duration}s to {count} chests of {player}.");
        defaults.put("boost_received", "&aYou received a temporary sell chest boost: {boost}x for {duration}s!");
        defaults.put("boost_usage", "&cUsage: /msc boost <player> <boost> <duration_seconds>");
        defaults.put("boost_invalid", "&cInvalid boost or duration!");
        defaults.put("boost_player_not_found", "&cPlayer not found!");
        defaults.put("boost_time_left", "&8(&c[Time]s left&8)");
        defaults.put("trasher_mode_KEEP", "Keep");
        defaults.put("trasher_mode_TRANSFER", "Transfer");
        defaults.put("trasher_mode_REMOVE", "Remove");
        defaults.put("booster_give_success", "&aGiven {amount}x booster voucher ({booster}) to {player}!");
        defaults.put("booster_give_usage", "&cUsage: /msc boost give <player> <boosterId> <amount>");
        defaults.put("booster_not_found", "&cBooster not found!");
        defaults.put("booster_item_not_defined", "&cBooster item not defined!");
        defaults.put("boosters_yml_not_found", "&cboosters.yml not found!");
        defaults.put("booster_invalid_amount", "&cInvalid amount!");
        defaults.put("booster_activated", "&aYour boost {boost} has been activated for {duration}s!");
        defaults.put("unknown_subcommand", "&cUnknown subcommand!");
        defaults.put("reload_success", "&aConfig and messages reloaded!");
        defaults.put("give_usage", "&cUsage: /msc give <player> <chest> <amount>");
        defaults.put("give_invalid_amount", "&cInvalid amount!");
        defaults.put("give_player_not_found", "&cPlayer not found!");
        defaults.put("give_chest_type_not_found", "&cChest type not found!");
        defaults.put("give_success", "&aGiven {amount}x {chest} sell chest to {player}!");
        defaults.put("booster_already_active", "&cYou already have an active boost!");
        boolean changed = false;
        for (Map.Entry entry : defaults.entrySet()) {
            if (this.messages.contains((String)entry.getKey())) continue;
            this.messages.set((String)entry.getKey(), entry.getValue());
            changed = true;
        }
        if (changed) {
            try {
                this.messages.save(messagesFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getString(String path) {
        String message = this.messages.getString(path);
        if (message == null) {
            return "Missing message: " + path;
        }
        return ColorSystem.colorize(message);
    }

    public String getString(String path, String defaultValue) {
        String message = this.messages.getString(path, defaultValue);
        return ColorSystem.colorize(message);
    }

    public FileConfiguration getMessages() {
        return this.messages;
    }
}

