/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.Commands;
import eu.mrneznamy.mrSellChests.Messages;
import eu.mrneznamy.mrSellChests.SellChestListener;
import eu.mrneznamy.mrSellChests.SellChestManager;
import eu.mrneznamy.mrSellChests.TabComplete;
import eu.mrneznamy.mrSellChests.integration.MrSellChestsItemProviderWrapper;
import eu.mrneznamy.mrSellChests.util.CheckUpdates;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class MrSellChests
extends JavaPlugin {
    private Messages messages;
    private SellChestListener sellChestListener;
    private SellChestManager sellChestManager;
    private Economy economy;
    private String prefix;
    private YamlConfiguration boostersConfig;
    private MrSellChestsItemProviderWrapper itemProviderWrapper;
    private Object itemProvider;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.messages = new Messages(this);
        this.prefix = this.messages.getString("prefix", "&8[&aMrSellChests&8]");
        this.saveDefaultConfig();
        CheckUpdates updater = new CheckUpdates();
        updater.EnableMessage();
        updater.checkForUpdates();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Disabled due to no Vault dependency found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.sellChestManager = new SellChestManager(this);
        this.getCommand("msc").setExecutor((CommandExecutor)new Commands(this));
        this.getCommand("msc").setTabCompleter((TabCompleter)new TabComplete(this));
        this.sellChestListener = new SellChestListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.sellChestListener, (Plugin)this);
        this.sellChestListener.removeAllSellChestHolograms();
        this.sellChestListener.restoreAllSellChestHolograms();
        File boostersFile = new File(this.getDataFolder(), "boosters.yml");
        if (!boostersFile.exists()) {
            try {
                this.saveResource("boosters.yml", false);
            }
            catch (Exception e) {
                try {
                    PrintWriter writer = new PrintWriter(boostersFile, "UTF-8");
                    writer.println("Boosters:");
                    writer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.boostersConfig = YamlConfiguration.loadConfiguration((File)boostersFile);
        this.registerCustomItems();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void reloadMessages() {
        this.messages.loadMessages();
        this.prefix = this.messages.getString("prefix", "&8[&aMrSellChests&8]");
    }

    public String getMessage(String path) {
        String message = this.messages.getString(path);
        if (message == null) {
            return "";
        }
        if (path.startsWith("state_") || path.startsWith("trasher_mode_")) {
            return message;
        }
        return this.prefix + " " + message;
    }

    public String getMessage(String path, String defaultValue) {
        String message = this.messages.getString(path, defaultValue);
        if (path.startsWith("state_") || path.startsWith("trasher_mode_")) {
            return message;
        }
        return this.prefix + " " + message;
    }

    public FileConfiguration getMessages() {
        return this.messages.getMessages();
    }

    public SellChestManager getSellChestManager() {
        return this.sellChestManager;
    }

    public void onDisable() {
        if (this.sellChestListener != null) {
            this.sellChestListener.removeAllSellChestHolograms();
        }
        if (this.sellChestManager != null) {
            this.sellChestManager.shutdown();
        }
        if (this.itemProvider != null && Bukkit.getPluginManager().getPlugin("MrUltimateShop") != null) {
            try {
                Class<?> apiClass = Class.forName("eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI");
                Method unregisterMethod = apiClass.getMethod("unregisterItemProvider", String.class);
                unregisterMethod.invoke(null, "MrSellChests");
                this.getLogger().info("Custom items unregistered from MrUltimateShop!");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to unregister custom items: " + e.getMessage());
            }
        }
    }

    private void registerCustomItems() {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            block5: {
                if (Bukkit.getPluginManager().getPlugin("MrUltimateShop") != null) {
                    try {
                        Class<?> apiClass = Class.forName("eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI");
                        Method registerMethod = apiClass.getMethod("registerItemProvider", Class.forName("eu.mrneznamy.mrultimateshop.api.CustomItemProvider"));
                        this.itemProviderWrapper = new MrSellChestsItemProviderWrapper(this);
                        this.itemProvider = this.itemProviderWrapper.createProvider();
                        if (this.itemProvider != null) {
                            registerMethod.invoke(null, this.itemProvider);
                            Method getAvailableItemsMethod = this.itemProvider.getClass().getMethod("getAvailableItems", new Class[0]);
                            Object[] availableItems = (String[])getAvailableItemsMethod.invoke(this.itemProvider, new Object[0]);
                            this.getLogger().info("Custom items registered with MrUltimateShop! Available items: " + Arrays.toString(availableItems));
                            break block5;
                        }
                        this.getLogger().warning("Failed to create item provider wrapper!");
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to register custom items with MrUltimateShop: " + e.getMessage());
                    }
                } else {
                    this.getLogger().info("MrUltimateShop not found! Custom items will not be available in shop.");
                }
            }
        }, 20L);
    }

    public YamlConfiguration getBoostersConfig() {
        return this.boostersConfig;
    }
}

