/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrSellChests.holograms.HologramManager;
import eu.mrneznamy.mrSellChests.util.ColorSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SellChestListener
implements Listener {
    private final MrSellChests plugin;
    private final Map<UUID, String> linkingPlayers;
    private BukkitTask hologramUpdateTask;
    private final HologramManager hologramManager;
    private boolean isUpdating = false;

    public SellChestListener(MrSellChests plugin) {
        this.plugin = plugin;
        this.linkingPlayers = new HashMap<UUID, String>();
        this.hologramManager = new HologramManager(plugin);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, this::startHologramUpdateTask, 40L);
    }

    private void startHologramUpdateTask() {
        if (this.hologramUpdateTask != null) {
            this.hologramUpdateTask.cancel();
            this.hologramUpdateTask = null;
        }
        if (this.hologramManager.isHologramsEnabled()) {
            int updateInterval = this.plugin.getConfig().getInt("MrSellChests.Holograms.UpdateInterval", 20);
            this.hologramUpdateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                if (!this.isUpdating) {
                    this.updateAllHolograms();
                }
            }, 20L, Math.max(5L, (long)updateInterval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllHolograms() {
        if (this.hologramManager.isHologramsEnabled()) {
            this.isUpdating = true;
            try {
                File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
                if (dataFile.exists()) {
                    YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                    for (String key : data.getKeys(false)) {
                        try {
                            List hologramLines;
                            String chestType;
                            String[] parts;
                            if (!data.getBoolean(key + ".hologram_enabled", true) || (parts = key.split(":")).length != 4 || (chestType = data.getString(key + ".type")) == null || (hologramLines = this.plugin.getConfig().getStringList("SellChests." + chestType + ".Hologram")).isEmpty()) continue;
                            String ownerName = data.getString(key + ".owner", "Unknown");
                            double boosterValue = this.plugin.getSellChestManager().getTotalBooster(key);
                            long boostTime = this.plugin.getSellChestManager().getBoostTimeLeft(key);
                            Object booster = String.format("%.2f", boosterValue);
                            if (boostTime > 0L) {
                                String timeMsg = this.plugin.getMessages().getString("boost_time_left").replace("[Time]", String.valueOf(boostTime));
                                booster = (String)booster + "x " + timeMsg;
                            }
                            int itemsSold = data.getInt(key + ".statistics.items_sold", 0);
                            int deletedItems = data.getInt(key + ".statistics.deleted_items", 0);
                            double moneyEarned = data.getDouble(key + ".statistics.money_earned", 0.0);
                            int remainingSeconds = this.plugin.getSellChestManager().getRemainingSeconds(key);
                            ArrayList<String> updatedLines = new ArrayList<String>();
                            for (String line : hologramLines) {
                                String updatedLine = line.replace("[PlayerName]", ownerName).replace("[Booster]", (CharSequence)booster).replace("[ItemsSold]", String.valueOf(itemsSold)).replace("[DeletedItems]", String.valueOf(deletedItems)).replace("[MoneyEarned]", String.format("%.2f", moneyEarned)).replace("[Interval]", String.valueOf(remainingSeconds));
                                updatedLines.add(ColorSystem.colorize(updatedLine));
                            }
                            String holoName = "sellchest_" + parts[0] + "_" + parts[1] + "_" + parts[2] + "_" + parts[3];
                            double yOffset = 1.45 + (double)hologramLines.size() * 0.25;
                            String provider = this.plugin.getConfig().getString("MrSellChests.Holograms.Provider", "DecentHolograms");
                            if ("CMIHolograms".equals(provider)) {
                                yOffset -= 0.5;
                            }
                            Location holoLoc = new Location(Bukkit.getWorld((String)parts[0]), Double.parseDouble(parts[1]) + 0.5, Double.parseDouble(parts[2]) + yOffset, Double.parseDouble(parts[3]) + 0.5);
                            if (!this.hologramManager.hologramExists(holoName)) {
                                this.hologramManager.createHologram(holoName, holoLoc, updatedLines);
                                continue;
                            }
                            this.hologramManager.updateHologram(holoName, updatedLines);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error updating hologram for key: " + key);
                            e.printStackTrace();
                        }
                    }
                    return;
                }
                this.isUpdating = false;
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemMeta meta;
        ItemStack item = event.getItemInHand();
        if (item != null && item.getType() != Material.AIR && (meta = item.getItemMeta()) != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "sellchest_type");
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(key, PersistentDataType.STRING)) {
                String chestType = (String)container.get(key, PersistentDataType.STRING);
                FileConfiguration config = this.plugin.getConfig();
                if (config.isConfigurationSection("SellChests." + chestType)) {
                    Player player = event.getPlayer();
                    if (!player.hasPermission("mrsellchests.place." + chestType)) {
                        event.setCancelled(true);
                        player.sendMessage(ColorSystem.colorize(this.plugin.getMessages().getString("no_permission_place", "&cYou don't have permission to place this type of sell chest!")));
                    } else {
                        List hologramLines;
                        int playerLimit = 0;
                        for (int i = 100; i >= 1; --i) {
                            if (!player.hasPermission("mrsellchests.limit." + i)) continue;
                            playerLimit = i;
                            break;
                        }
                        if (playerLimit > 0) {
                            File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
                            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                            int currentChests = 0;
                            for (String existingKey : data.getKeys(false)) {
                                String ownerUUID = data.getString(existingKey + ".player_uuid");
                                if (ownerUUID == null || !ownerUUID.equals(player.getUniqueId().toString())) continue;
                                ++currentChests;
                            }
                            if (currentChests >= playerLimit) {
                                event.setCancelled(true);
                                String message = this.plugin.getMessage("chest_limit_reached", "&cYou have reached your limit of {limit} sell chests!").replace("{limit}", String.valueOf(playerLimit));
                                player.sendMessage(ColorSystem.colorize(message));
                                return;
                            }
                        }
                        Block block = event.getBlockPlaced();
                        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
                        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                        for (String existingKey : data.getKeys(false)) {
                            String[] parts = existingKey.split(":");
                            if (parts.length != 4) continue;
                            String world = parts[0];
                            int x = Integer.parseInt(parts[1]);
                            int y = Integer.parseInt(parts[2]);
                            int z = Integer.parseInt(parts[3]);
                            if (!world.equals(block.getWorld().getName()) || x >> 4 != block.getX() >> 4 || z >> 4 != block.getZ() >> 4) continue;
                            event.setCancelled(true);
                            event.getPlayer().sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_same_chunk")));
                            return;
                        }
                        this.saveSellChest(block, chestType, player.getName());
                        String chestPath = "SellChests." + chestType + ".Chest";
                        String type = config.getString(chestPath + ".Type");
                        if ("TIME".equals(type)) {
                            String var10000 = block.getWorld().getName();
                            String chestKey = var10000 + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ();
                            this.plugin.getSellChestManager().registerChestInventory(chestKey, chestType);
                        }
                        if (this.hologramManager.isHologramsEnabled() && !(hologramLines = this.plugin.getConfig().getStringList("SellChests." + chestType + ".Hologram")).isEmpty()) {
                            double yOffset = 1.45 + (double)hologramLines.size() * 0.25;
                            Location holoLoc = block.getLocation().clone().add(0.5, yOffset, 0.5);
                            ArrayList<String> updatedLines = new ArrayList<String>();
                            for (String line : hologramLines) {
                                line = line.replace("[PlayerName]", player.getName()).replace("[Booster]", "1.0").replace("[ItemsSold]", "0").replace("[DeletedItems]", "0").replace("[MoneyEarned]", "0.00").replace("[Interval]", String.valueOf(this.plugin.getConfig().getInt("SellChests." + chestType + ".Chest.Interval", 10)));
                                updatedLines.add(ColorSystem.colorize(line));
                            }
                            String var40 = block.getWorld().getName();
                            String holoName = "sellchest_" + var40 + "_" + block.getX() + "_" + block.getY() + "_" + block.getZ();
                            this.hologramManager.createHologram(holoName, holoLoc, updatedLines);
                        }
                        player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_created")));
                    }
                }
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        YamlConfiguration data;
        Location loc = event.getBlock().getLocation();
        String var10000 = loc.getWorld().getName();
        String key = var10000 + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (dataFile.exists() && (data = YamlConfiguration.loadConfiguration((File)dataFile)).contains(key)) {
            Player player = event.getPlayer();
            String ownerUUID = data.getString(key + ".player_uuid");
            if (!player.getUniqueId().toString().equals(ownerUUID) && !player.hasPermission("mrsellchests.destroy.others")) {
                event.setCancelled(true);
                player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("no_chest_destroy")));
            } else {
                String chestType = data.getString(key + ".type");
                if (chestType != null) {
                    event.setDropItems(false);
                    ItemStack sellChest = this.plugin.getSellChestManager().createSellChestItem(chestType);
                    loc.getWorld().dropItemNaturally(loc, sellChest);
                    var10000 = loc.getWorld().getName();
                    String holoName = "sellchest_" + var10000 + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
                    this.hologramManager.deleteHologram(holoName);
                    this.plugin.getSellChestManager().removeChest(key);
                    data.set(key, null);
                    try {
                        data.save(dataFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                    player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_destroyed")));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        String var61;
        String key;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            NamespacedKey boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_voucher");
            if (meta.getPersistentDataContainer().has(boosterKey, PersistentDataType.STRING)) {
                ConfigurationSection booster;
                YamlConfiguration boosters;
                File boostersFile;
                boolean stackable;
                String boosterId = (String)meta.getPersistentDataContainer().get(boosterKey, PersistentDataType.STRING);
                NamespacedKey stackableKey = new NamespacedKey((Plugin)this.plugin, "booster_stackable");
                boolean bl = stackable = meta.getPersistentDataContainer().has(stackableKey, PersistentDataType.INTEGER) && (Integer)meta.getPersistentDataContainer().get(stackableKey, PersistentDataType.INTEGER) == 1;
                if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && (boostersFile = new File(this.plugin.getDataFolder(), "boosters.yml")).exists() && (boosters = YamlConfiguration.loadConfiguration((File)boostersFile)).isConfigurationSection("Boosters." + (String)boosterId) && (booster = boosters.getConfigurationSection("Boosters." + (String)boosterId + ".Head")) != null) {
                    double boost = booster.getDouble("Boost", 1.0);
                    long duration = booster.getLong("Duration", 60L);
                    long now = System.currentTimeMillis();
                    File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
                    YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                    String playerBoostPath = "players." + String.valueOf(player.getUniqueId()) + ".boost_temp";
                    boolean hasActive = false;
                    double currentBoost = 0.0;
                    long currentUntil = 0L;
                    if (data.contains(playerBoostPath + ".value") && data.contains(playerBoostPath + ".until")) {
                        currentBoost = data.getDouble(playerBoostPath + ".value", 0.0);
                        currentBoost = (double)Math.round(currentBoost * 100.0) / 100.0;
                        currentUntil = data.getLong(playerBoostPath + ".until", 0L);
                        if (currentUntil > now) {
                            hasActive = true;
                        }
                    }
                    double roundedBoost = (double)Math.round(boost * 100.0) / 100.0;
                    if (stackable) {
                        if (hasActive) {
                            if (!(Math.abs(currentBoost - roundedBoost) < 1.0E-4)) {
                                String msg = this.plugin.getMessage("booster_already_active");
                                player.sendMessage(ColorSystem.colorize(msg));
                                event.setCancelled(true);
                                return;
                            }
                            long newUntil = currentUntil + duration * 1000L;
                            data.set(playerBoostPath + ".until", (Object)newUntil);
                            try {
                                data.save(dataFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            until = now + duration * 1000L;
                            data.set(playerBoostPath + ".value", (Object)roundedBoost);
                            data.set(playerBoostPath + ".until", (Object)until);
                            try {
                                data.save(dataFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        if (hasActive && currentUntil > now) {
                            String msg = this.plugin.getMessage("booster_already_active");
                            player.sendMessage(ColorSystem.colorize(msg));
                            event.setCancelled(true);
                            return;
                        }
                        until = now + duration * 1000L;
                        data.set(playerBoostPath + ".value", (Object)roundedBoost);
                        data.set(playerBoostPath + ".until", (Object)until);
                        try {
                            data.save(dataFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (item.getAmount() > 1) {
                        item.setAmount(item.getAmount() - 1);
                    } else {
                        player.getInventory().setItem(event.getHand() == EquipmentSlot.HAND ? player.getInventory().getHeldItemSlot() : player.getInventory().getHeldItemSlot(), (ItemStack)null);
                    }
                    String msg = this.plugin.getMessage("booster_activated").replace("{boost}", String.valueOf(boost)).replace("{duration}", String.valueOf(duration));
                    player.sendMessage(ColorSystem.colorize(msg));
                    event.setCancelled(true);
                    return;
                }
            }
        }
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        for (String existingKey : data.getKeys(false)) {
            if (!data.getBoolean(existingKey + ".linking", false)) continue;
            event.setCancelled(true);
            if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
                if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null) {
                    Block block2 = event.getClickedBlock();
                    String var10000 = block2.getWorld().getName();
                    String clickedKey = var10000 + ":" + block2.getX() + ":" + block2.getY() + ":" + block2.getZ();
                    if (data.contains(clickedKey)) {
                        player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_link_sell_chest")));
                        return;
                    }
                    if (!(block2.getState() instanceof Container)) {
                        player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_link_invalid")));
                        return;
                    }
                    String chestType = data.getString(existingKey + ".type");
                    int maxLinks = this.plugin.getConfig().getInt("SellChests." + chestType + ".Chest.MaxLinks", 1);
                    List linkedChests = data.getList(existingKey + ".linked_chests", new ArrayList());
                    if (linkedChests.size() >= maxLinks) {
                        String message = this.plugin.getMessage("chest_link_max").replace("{current}", String.valueOf(linkedChests.size())).replace("{max}", String.valueOf(maxLinks));
                        player.sendMessage(ColorSystem.colorize(message));
                        data.set(existingKey + ".linking", (Object)false);
                        try {
                            data.save(dataFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    var10000 = block2.getWorld().getName();
                    String chestLoc = var10000 + "," + block2.getX() + "," + block2.getY() + "," + block2.getZ();
                    if (!linkedChests.contains(chestLoc)) {
                        linkedChests.add(chestLoc);
                        data.set(existingKey + ".linked_chests", (Object)linkedChests);
                    }
                    data.set(existingKey + ".linking", (Object)false);
                    try {
                        data.save(dataFile);
                        String message = this.plugin.getMessage("chest_link_success").replace("{current}", String.valueOf(linkedChests.size())).replace("{max}", String.valueOf(maxLinks));
                        player.sendMessage(ColorSystem.colorize(message));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                return;
            }
            data.set(existingKey + ".linking", (Object)false);
            try {
                data.save(dataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_link_cancelled")));
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && data.contains(key = (var61 = (block = event.getClickedBlock()).getWorld().getName()) + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ())) {
            event.setCancelled(true);
            String chestType = data.getString(key + ".type");
            if (chestType != null) {
                data.getString(key + ".owner");
                String playerUUID = player.getUniqueId().toString();
                String ownerUUID = data.getString(key + ".player_uuid");
                if (!playerUUID.equals(ownerUUID) && !player.hasPermission("mrsellchests.open.others")) {
                    player.sendMessage(ColorSystem.colorize(this.plugin.getMessages().getString("no_chest_access")));
                } else if (event.getPlayer().isSneaking()) {
                    Inventory inv = this.plugin.getSellChestManager().getChestInventory(key);
                    if (inv != null) {
                        player.openInventory(inv);
                    }
                } else {
                    this.plugin.getSellChestManager().openSettingsMenu(player, key);
                }
            }
        }
    }

    private void saveSellChest(Block block, String chestType, String owner) {
        try {
            File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            String var10000 = block.getWorld().getName();
            String key = var10000 + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ();
            data.set(key + ".type", (Object)chestType);
            data.set(key + ".owner", (Object)owner);
            data.set(key + ".uuid", (Object)block.getWorld().getUID().toString());
            data.set(key + ".world", (Object)block.getWorld().getName());
            data.set(key + ".x", (Object)block.getX());
            data.set(key + ".y", (Object)block.getY());
            data.set(key + ".z", (Object)block.getZ());
            data.set(key + ".statistics.items_sold", (Object)0);
            data.set(key + ".statistics.deleted_items", (Object)0);
            data.set(key + ".statistics.money_earned", (Object)0.0);
            data.set(key + ".hologram_enabled", (Object)true);
            data.set(key + ".chunk_collector_enabled", (Object)false);
            data.set(key + ".trasher_mode", (Object)"REMOVE");
            Player placer = Bukkit.getPlayerExact((String)owner);
            if (placer != null) {
                data.set(key + ".player_uuid", (Object)placer.getUniqueId().toString());
            }
            data.save(dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeAllSellChestHolograms() {
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (dataFile.exists()) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            for (String key : data.getKeys(false)) {
                String[] parts = key.split(":");
                if (parts.length != 4) continue;
                String holoName = "sellchest_" + parts[0] + "_" + parts[1] + "_" + parts[2] + "_" + parts[3];
                this.hologramManager.deleteHologram(holoName);
            }
        }
    }

    public void restoreAllSellChestHolograms() {
        this.removeAllSellChestHolograms();
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (dataFile.exists()) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            for (String key : data.getKeys(false)) {
                try {
                    List hologramLines;
                    String chestType;
                    String[] parts;
                    if (!data.getBoolean(key + ".hologram_enabled", true) || (parts = key.split(":")).length != 4 || (chestType = data.getString(key + ".type")) == null || (hologramLines = this.plugin.getConfig().getStringList("SellChests." + chestType + ".Hologram")).isEmpty()) continue;
                    Location loc = new Location(Bukkit.getWorld((String)parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                    double yOffset = 1.45 + (double)hologramLines.size() * 0.25;
                    Location holoLoc = loc.clone().add(0.5, yOffset, 0.5);
                    String ownerName = data.getString(key + ".owner", "Unknown");
                    double boosterValue = this.plugin.getSellChestManager().getTotalBooster(key);
                    long boostTime = this.plugin.getSellChestManager().getBoostTimeLeft(key);
                    Object booster = String.format("%.2f", boosterValue);
                    if (boostTime > 0L) {
                        String timeMsg = this.plugin.getMessages().getString("boost_time_left").replace("[Time]", String.valueOf(boostTime));
                        booster = (String)booster + "x " + timeMsg;
                    }
                    int itemsSold = data.getInt(key + ".statistics.items_sold", 0);
                    int deletedItems = data.getInt(key + ".statistics.deleted_items", 0);
                    double moneyEarned = data.getDouble(key + ".statistics.money_earned", 0.0);
                    int remainingSeconds = this.plugin.getSellChestManager().getRemainingSeconds(key);
                    ArrayList<String> updatedLines = new ArrayList<String>();
                    for (String line : hologramLines) {
                        String updatedLine = line.replace("[PlayerName]", ownerName).replace("[Booster]", (CharSequence)booster).replace("[ItemsSold]", String.valueOf(itemsSold)).replace("[DeletedItems]", String.valueOf(deletedItems)).replace("[MoneyEarned]", String.format("%.2f", moneyEarned)).replace("[Interval]", String.valueOf(remainingSeconds));
                        updatedLines.add(updatedLine);
                    }
                    String holoName = "sellchest_" + parts[0] + "_" + parts[1] + "_" + parts[2] + "_" + parts[3];
                    this.hologramManager.createHologram(holoName, holoLoc, updatedLines);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler
    public void onSettingsMenuClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player && event.getView().getTitle().equals(ColorSystem.colorize(this.plugin.getConfig().getString("SettingsMenu.title", "&8Sell Chest Menu")))) {
            ItemMeta meta;
            event.setCancelled(true);
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && clicked.getType() != Material.AIR && (meta = clicked.getItemMeta()) != null) {
                String chestKey = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "chest_key"), PersistentDataType.STRING);
                String action = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "menu_action"), PersistentDataType.STRING);
                if (chestKey != null && action != null) {
                    boolean isLinkItem = meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "Link_Item"), PersistentDataType.STRING);
                    Player player = (Player)event.getWhoClicked();
                    File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
                    YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                    switch (action) {
                        case "sell_inventory": {
                            player.closeInventory();
                            player.openInventory(this.plugin.getSellChestManager().getChestInventory(chestKey));
                            break;
                        }
                        case "trasher": {
                            if (isLinkItem) {
                                String chestType = data.getString(chestKey + ".type");
                                int maxLinks = this.plugin.getConfig().getInt("SellChests." + chestType + ".Chest.MaxLinks", 1);
                                List linkedChests = data.getList(chestKey + ".linked_chests", new ArrayList());
                                if (event.isRightClick()) {
                                    data.set(chestKey + ".linked_chests", null);
                                    try {
                                        data.save(dataFile);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    player.closeInventory();
                                    player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_unlink_all")));
                                    this.plugin.getSellChestManager().openSettingsMenu(player, chestKey);
                                    break;
                                }
                                if (linkedChests.size() >= maxLinks) {
                                    player.closeInventory();
                                    player.sendMessage(ColorSystem.colorize(this.plugin.getMessage("chest_link_max_disabled").replace("{max}", String.valueOf(maxLinks))));
                                    return;
                                }
                                data.set(chestKey + ".linking", (Object)true);
                                try {
                                    data.save(dataFile);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                player.closeInventory();
                                String message = this.plugin.getMessage("chest_link_start").replace("{current}", String.valueOf(linkedChests.size())).replace("{max}", String.valueOf(maxLinks));
                                player.sendMessage(ColorSystem.colorize(message));
                                break;
                            }
                            String currentMode = data.getString(chestKey + ".trasher_mode", "REMOVE");
                            String newMode = "REMOVE".equals(currentMode = currentMode.toUpperCase()) ? "KEEP" : ("KEEP".equals(currentMode) ? "TRANSFER" : "REMOVE");
                            data.set(chestKey + ".trasher_mode", (Object)newMode);
                            String rawMessage = this.plugin.getMessages().getString("trasher_mode_changed");
                            String prefix = this.plugin.getMessages().getString("prefix");
                            String modeDisplay = this.plugin.getMessage("trasher_mode_" + newMode);
                            String message = prefix + " " + rawMessage.replace("{mode}", modeDisplay);
                            player.sendMessage(ColorSystem.colorize(message));
                            try {
                                data.save(dataFile);
                                this.plugin.getSellChestManager().updateTrasherItem(event.getInventory(), chestKey, newMode);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "toggle_hologram": {
                            boolean currentHologram = data.getBoolean(chestKey + ".hologram_enabled", true);
                            boolean newHologramState = !currentHologram;
                            data.set(chestKey + ".hologram_enabled", (Object)newHologramState);
                            try {
                                data.save(dataFile);
                                String[] parts = chestKey.split(":");
                                if (parts.length == 4) {
                                    String holoName = "sellchest_" + parts[0] + "_" + parts[1] + "_" + parts[2] + "_" + parts[3];
                                    if (!newHologramState) {
                                        this.hologramManager.deleteHologram(holoName);
                                    } else {
                                        List hologramLines;
                                        String chestType = data.getString(chestKey + ".type");
                                        if (chestType != null && !(hologramLines = this.plugin.getConfig().getStringList("SellChests." + chestType + ".Hologram")).isEmpty()) {
                                            String owner = data.getString(chestKey + ".owner", "Unknown");
                                            double boosterValue = this.plugin.getSellChestManager().getTotalBooster(chestKey);
                                            long boostTime = this.plugin.getSellChestManager().getBoostTimeLeft(chestKey);
                                            Object booster = String.format("%.2f", boosterValue);
                                            if (boostTime > 0L) {
                                                String timeMsg = this.plugin.getMessages().getString("boost_time_left").replace("[Time]", String.valueOf(boostTime));
                                                booster = (String)booster + " " + timeMsg;
                                            }
                                            int itemsSold = data.getInt(chestKey + ".statistics.items_sold", 0);
                                            int deletedItems = data.getInt(chestKey + ".statistics.deleted_items", 0);
                                            double moneyEarned = data.getDouble(chestKey + ".statistics.money_earned", 0.0);
                                            int remainingSeconds = this.plugin.getSellChestManager().getRemainingSeconds(chestKey);
                                            ArrayList<String> updatedLines = new ArrayList<String>();
                                            for (String line : hologramLines) {
                                                String updatedLine = line.replace("[PlayerName]", owner).replace("[Booster]", (CharSequence)booster).replace("[ItemsSold]", String.valueOf(itemsSold)).replace("[DeletedItems]", String.valueOf(deletedItems)).replace("[MoneyEarned]", String.format("%.2f", moneyEarned)).replace("[Interval]", String.valueOf(remainingSeconds));
                                                updatedLines.add(ColorSystem.colorize(updatedLine));
                                            }
                                            int x = Integer.parseInt(parts[1]);
                                            int y = Integer.parseInt(parts[2]);
                                            int z = Integer.parseInt(parts[3]);
                                            double yOffset = 1.45 + (double)hologramLines.size() * 0.25;
                                            Location holoLoc = new Location(this.plugin.getServer().getWorld(parts[0]), (double)x + 0.5, (double)y + yOffset, (double)z + 0.5);
                                            this.hologramManager.deleteHologram(holoName);
                                            this.hologramManager.createHologram(holoName, holoLoc, updatedLines);
                                        }
                                    }
                                }
                                this.plugin.getSellChestManager().updateHologramItem(event.getInventory(), chestKey, newHologramState);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "chunk_collector": {
                            boolean currentCollector = data.getBoolean(chestKey + ".chunk_collector_enabled", false);
                            boolean newCollectorState = !currentCollector;
                            data.set(chestKey + ".chunk_collector_enabled", (Object)newCollectorState);
                            try {
                                data.save(dataFile);
                                if (newCollectorState) {
                                    String chestType;
                                    String[] parts = chestKey.split(":");
                                    if (parts.length == 4 && (chestType = data.getString(chestKey + ".type")) != null) {
                                        int interval = this.plugin.getConfig().getInt("SellChests." + chestType + ".Chest.CollectorInterval", 5);
                                        Location loc = new Location(Bukkit.getWorld((String)parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                                        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                                            if (data.getBoolean(chestKey + ".chunk_collector_enabled", false)) {
                                                for (Entity entity : loc.getChunk().getEntities()) {
                                                    if (!(entity instanceof Item)) continue;
                                                    Item item = (Item)entity;
                                                    ItemStack stack = item.getItemStack();
                                                    if (!this.plugin.getSellChestManager().addItemToChest(chestKey, stack)) continue;
                                                    item.remove();
                                                }
                                            }
                                        }, 20L * (long)interval, 20L * (long)interval);
                                        data.set(chestKey + ".collector_task_id", (Object)task.getTaskId());
                                        data.save(dataFile);
                                    }
                                } else {
                                    int taskId = data.getInt(chestKey + ".collector_task_id", -1);
                                    if (taskId != -1) {
                                        Bukkit.getScheduler().cancelTask(taskId);
                                        data.set(chestKey + ".collector_task_id", null);
                                        data.save(dataFile);
                                    }
                                }
                                this.plugin.getSellChestManager().updateCollectorItem(event.getInventory(), chestKey, newCollectorState);
                                break;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Inventory source = event.getSource();
        Inventory destination = event.getDestination();
        String sellTitle = ColorSystem.colorize(this.plugin.getConfig().getString("SettingsMenu.titleforsellinv", "&8Sell Inventory"));
        if (destination.getHolder() instanceof Container) {
            if (source.getHolder() == null) {
                String viewTitle;
                String string = viewTitle = event.getSource().getViewers().isEmpty() ? "" : ((HumanEntity)event.getSource().getViewers().get(0)).getOpenInventory().getTitle();
                if (viewTitle.equals(sellTitle)) {
                    event.setCancelled(true);
                    return;
                }
            }
            File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            for (String key : data.getKeys(false)) {
                String viewTitle;
                Container destContainer;
                Location destLoc;
                String var10000;
                String destLocStr;
                List linkedChests;
                String trasherMode = data.getString(key + ".trasher_mode", "REMOVE");
                if (!"TRANSFER".equals(trasherMode) || (linkedChests = data.getList(key + ".linked_chests", new ArrayList())) == null || linkedChests.isEmpty() || !linkedChests.contains(destLocStr = (var10000 = (destLoc = (destContainer = (Container)destination.getHolder()).getLocation()).getWorld().getName()) + "," + destLoc.getX() + "," + destLoc.getY() + "," + destLoc.getZ())) continue;
                String string = viewTitle = event.getSource().getViewers().isEmpty() ? "" : ((HumanEntity)event.getSource().getViewers().get(0)).getOpenInventory().getTitle();
                if (!viewTitle.equals(sellTitle)) {
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
        }
    }
}

