/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests.holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import eu.mrneznamy.mrSellChests.holograms.HologramProvider;
import eu.mrneznamy.mrSellChests.util.ColorSystem;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class CMIHologramProvider
implements HologramProvider {
    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        List colorizedLines = lines.stream().map(ColorSystem::colorize).collect(Collectors.toList());
        Location adjustedLocation = location.clone();
        adjustedLocation.subtract(0.0, 0.5, 0.0);
        CMIHologram hologram = new CMIHologram(name, adjustedLocation);
        hologram.setLines(colorizedLines);
        CMI.getInstance().getHologramManager().addHologram(hologram);
        hologram.update();
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        CMIHologram hologram = CMI.getInstance().getHologramManager().getByName(name);
        if (hologram == null) {
            return;
        }
        List colorizedLines = lines.stream().map(ColorSystem::colorize).collect(Collectors.toList());
        hologram.setLines(colorizedLines);
        hologram.update();
    }

    @Override
    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        CMIHologram hologram = CMI.getInstance().getHologramManager().getByName(name);
        if (hologram != null) {
            hologram.remove();
        }
    }

    @Override
    public boolean isEnabled() {
        return Bukkit.getPluginManager().getPlugin("CMI") != null;
    }

    @Override
    public boolean hologramExists(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        return CMI.getInstance().getHologramManager().getByName(name) != null;
    }
}

