/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests.holograms;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrSellChests.holograms.CMIHologramProvider;
import eu.mrneznamy.mrSellChests.holograms.DecentHologramProvider;
import eu.mrneznamy.mrSellChests.holograms.HologramProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;

public class HologramManager {
    private final MrSellChests plugin;
    private final Map<String, HologramProvider> providers = new HashMap<String, HologramProvider>();
    private HologramProvider activeProvider;

    public HologramManager(MrSellChests plugin) {
        this.plugin = plugin;
        this.setupProviders();
    }

    private void setupProviders() {
        this.providers.put("DecentHolograms", new DecentHologramProvider());
        this.providers.put("CMIHolograms", new CMIHologramProvider());
        String providerName = this.plugin.getConfig().getString("MrSellChests.Holograms.Provider", "DecentHolograms");
        HologramProvider provider = this.providers.get(providerName);
        if (provider != null && provider.isEnabled()) {
            this.activeProvider = provider;
        } else {
            for (HologramProvider p : this.providers.values()) {
                if (!p.isEnabled()) continue;
                this.activeProvider = p;
                break;
            }
        }
    }

    public boolean isHologramsEnabled() {
        return this.plugin.getConfig().getConfigurationSection("MrSellChests.Holograms") != null && this.plugin.getConfig().getBoolean("MrSellChests.Holograms.Enabled", true) && this.activeProvider != null;
    }

    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isHologramsEnabled()) {
            return;
        }
        this.activeProvider.createHologram(name, location, lines);
    }

    public void updateHologram(String name, List<String> lines) {
        if (!this.isHologramsEnabled()) {
            return;
        }
        this.activeProvider.updateHologram(name, lines);
    }

    public void deleteHologram(String name) {
        if (!this.isHologramsEnabled()) {
            return;
        }
        this.activeProvider.deleteHologram(name);
    }

    public boolean hologramExists(String name) {
        if (!this.isHologramsEnabled()) {
            return false;
        }
        return this.activeProvider.hologramExists(name);
    }
}

