/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrlibcore.messages.MrLibMessage;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor {
    private final MrSellChests plugin;
    private FileConfiguration config;
    private MrLibMessage messageSystem;

    public Commands(MrSellChests plugin) {
        this.plugin = plugin;
        this.reloadConfigs();
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.messageSystem = this.plugin.getMessageSystem();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                MrLibHelper.showPluginHelp((Player)((Player)sender), (String)"MrSellChests", (int)1);
            } else {
                sender.sendMessage(this.plugin.getMessagesConfig().getString("command_usage", "&7Use: /msc <give|reload|boost|help>"));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessagesConfig().getString("help_players_only", "&cHelp command is only available for players!"));
                return true;
            }
            if (args.length == 1) {
                MrLibHelper.showPluginHelp((Player)((Player)sender), (String)"MrSellChests", (int)1);
            } else if (args.length == 2) {
                MrLibHelper.showPluginHelp((Player)((Player)sender), (String)args[1], (int)1);
            } else if (args.length == 3) {
                try {
                    int page = Integer.parseInt(args[2]);
                    MrLibHelper.showPluginHelp((Player)((Player)sender), (String)args[1], (int)page);
                }
                catch (NumberFormatException e) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("invalid_page_number", "&cInvalid page number!"));
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("mrsellchests.reload")) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("no_permission", "&cYou do not have permission to do this!"));
                return true;
            }
            this.reloadConfigs();
            this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("reload_success", "&aConfig and messages reloaded!"));
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            int amount;
            if (!sender.hasPermission("mrsellchests.give")) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("no_permission"));
                return true;
            }
            if (args.length < 4) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("give_usage", "&cUsage: /msc give <player> <chest> <amount>"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("give_player_not_found"));
                return true;
            }
            String chestType = args[2];
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException var9) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("give_invalid_amount"));
                return true;
            }
            if (!this.config.isConfigurationSection("MrSellChests.SellChests." + chestType)) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("give_chest_type_not_found"));
                return true;
            }
            ItemStack item = this.createSellChestItem(chestType, amount);
            HashMap leftovers = target.getInventory().addItem(new ItemStack[]{item});
            if (!leftovers.isEmpty()) {
                for (Object obj : leftovers.values()) {
                    ItemStack left = (ItemStack)obj;
                    target.getWorld().dropItemNaturally(target.getLocation(), left);
                }
            }
            String msg = this.plugin.getMessagesConfig().getString("give_success").replace("{amount}", String.valueOf(amount)).replace("{chest}", chestType).replace("{player}", target.getName());
            this.plugin.sendMessage((Player)sender, msg);
            return true;
        }
        if (args[0].equalsIgnoreCase("boost")) {
            long duration;
            double boost;
            if (!sender.hasPermission("mrsellchests.boost")) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("no_permission"));
                return true;
            }
            if (args.length >= 2 && args[1].equalsIgnoreCase("give")) {
                HashMap leftovers;
                ItemStack voucher;
                ItemMeta meta;
                int amount;
                if (args.length < 5) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("booster_give_usage"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("boost_player_not_found"));
                    return true;
                }
                String boosterId = args[3];
                try {
                    amount = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException e) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("booster_invalid_amount"));
                    return true;
                }
                File boostersFile = new File(this.plugin.getDataFolder(), "boosters.yml");
                if (!boostersFile.exists()) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("boosters_yml_not_found"));
                    return true;
                }
                YamlConfiguration boosters = YamlConfiguration.loadConfiguration((File)boostersFile);
                if (!boosters.isConfigurationSection("Boosters." + boosterId)) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("booster_not_found"));
                    return true;
                }
                ConfigurationSection booster = boosters.getConfigurationSection("Boosters." + boosterId);
                ConfigurationSection headSection = booster.getConfigurationSection("Head");
                ConfigurationSection itemSection = booster.getConfigurationSection("Item");
                if (itemSection == null) {
                    this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("booster_item_not_defined"));
                    return true;
                }
                String matName = itemSection.getString("Material", "PAPER");
                Material mat = Material.matchMaterial((String)matName);
                if (mat == null) {
                    mat = Material.PAPER;
                }
                if ((meta = (voucher = new ItemStack(mat, amount)).getItemMeta()) != null) {
                    if (itemSection.contains("CustomModelData") && !"NONE".equalsIgnoreCase(itemSection.getString("CustomModelData"))) {
                        try {
                            meta.setCustomModelData(Integer.valueOf(Integer.parseInt(itemSection.getString("CustomModelData"))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    meta.setDisplayName(MrLibColors.colorize((String)itemSection.getString("Name", this.plugin.getMessagesConfig().getString("booster_voucher_name", "&aBooster Voucher"))));
                    List lore = itemSection.getStringList("Lore");
                    if (!lore.isEmpty()) {
                        for (int i = 0; i < lore.size(); ++i) {
                            lore.set(i, MrLibColors.colorize((String)((String)lore.get(i))));
                        }
                        meta.setLore(lore);
                    }
                    if (itemSection.getBoolean("Glowing", false)) {
                        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    }
                    NamespacedKey boosterKey = new NamespacedKey((Plugin)this.plugin, "booster_voucher");
                    meta.getPersistentDataContainer().set(boosterKey, PersistentDataType.STRING, (Object)boosterId);
                    boolean stackable = headSection != null && headSection.getBoolean("Stackable", false);
                    NamespacedKey stackableKey = new NamespacedKey((Plugin)this.plugin, "booster_stackable");
                    meta.getPersistentDataContainer().set(stackableKey, PersistentDataType.INTEGER, (Object)(stackable ? 1 : 0));
                    voucher.setItemMeta(meta);
                }
                if (!(leftovers = target.getInventory().addItem(new ItemStack[]{voucher})).isEmpty()) {
                    for (Object obj : leftovers.values()) {
                        ItemStack left = (ItemStack)obj;
                        target.getWorld().dropItemNaturally(target.getLocation(), left);
                    }
                }
                String msg = this.plugin.getMessagesConfig().getString("booster_give_success").replace("{amount}", String.valueOf(amount)).replace("{booster}", boosterId).replace("{player}", target.getName());
                this.plugin.sendMessage((Player)sender, msg);
                return true;
            }
            if (args.length < 4) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("boost_usage"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("boost_player_not_found"));
                return true;
            }
            try {
                boost = Double.parseDouble(args[2]);
                duration = Long.parseLong(args[3]);
            }
            catch (NumberFormatException e) {
                this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("boost_invalid"));
                return true;
            }
            long until = System.currentTimeMillis() + duration * 1000L;
            File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            String playerPath = "players." + String.valueOf(target.getUniqueId()) + ".boost_temp";
            data.set(playerPath + ".value", (Object)boost);
            data.set(playerPath + ".until", (Object)until);
            try {
                data.save(dataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String msg = this.plugin.getMessagesConfig().getString("boost_set").replace("{boost}", String.valueOf(boost)).replace("{duration}", String.valueOf(duration)).replace("{count}", "all").replace("{player}", target.getName());
            this.plugin.sendMessage((Player)sender, msg);
            if (target.isOnline()) {
                String msg2 = this.plugin.getMessagesConfig().getString("boost_received").replace("{boost}", String.valueOf(boost)).replace("{duration}", String.valueOf(duration));
                this.plugin.sendMessage(target, msg2);
            }
            return true;
        }
        this.plugin.sendMessage((Player)sender, this.plugin.getMessagesConfig().getString("unknown_subcommand", "&cUnknown subcommand!"));
        return true;
    }

    private ItemStack createSellChestItem(String chestType, int amount) {
        ItemStack item;
        ItemMeta meta;
        String path = "MrSellChests.SellChests." + chestType + ".Item.";
        String materialName = this.config.getString("MrSellChests.SellChests." + chestType + ".Chest.Material", "CHEST");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.CHEST;
        }
        if ((meta = (item = new ItemStack(material, amount)).getItemMeta()) != null) {
            meta.setDisplayName(MrLibColors.colorize((String)this.config.getString(path + "Name", "Sell Chest")));
            List lore = this.config.getStringList(path + "Lore");
            if (!lore.isEmpty()) {
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, MrLibColors.colorize((String)((String)lore.get(i))));
                }
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "sellchest_type");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)chestType);
            item.setItemMeta(meta);
        }
        return item;
    }
}

