/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests.hologram;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SellChestHologramManager {
    private final MrSellChests plugin;
    private final Map<String, List<ArmorStand>> hologramsByKey;
    private final Map<String, List<String>> lastContent = new HashMap<String, List<String>>();

    public SellChestHologramManager(MrSellChests plugin) {
        this.plugin = plugin;
        this.hologramsByKey = new HashMap<String, List<ArmorStand>>();
    }

    public void showLines(String key, Location base, List<String> lines) {
        if (base == null || base.getWorld() == null || lines == null || lines.isEmpty()) {
            return;
        }
        List<String> lastLines = this.lastContent.get(key);
        if (lastLines != null && lastLines.equals(lines)) {
            return;
        }
        this.remove(key);
        this.lastContent.put(key, new ArrayList<String>(lines));
        World world = base.getWorld();
        String provider = this.plugin.getConfig().getString("MrSellChests.Holograms.Provider", "DecentHolograms");
        double yOffset = "CMI".equals(provider) ? -1.55 + (double)lines.size() * 0.2 - 0.5 : ("DecentHolograms".equals(provider) ? -1.55 + (double)lines.size() * 0.2 : -2.2 + (double)lines.size() * 0.3);
        double y = (double)base.getBlockY() + yOffset;
        double x = (double)base.getBlockX() + 0.5;
        double z = (double)base.getBlockZ() + 0.5;
        ArrayList<ArmorStand> list = new ArrayList<ArmorStand>();
        for (int i = lines.size() - 1; i >= 0; --i) {
            String raw = lines.get(i);
            if (raw == null || raw.trim().isEmpty()) continue;
            String line = MrLibColors.colorize((String)raw);
            Location loc = new Location(world, x, y + (double)(lines.size() - 1 - i) * 0.3, z);
            ArmorStand as = (ArmorStand)world.spawnEntity(loc, EntityType.ARMOR_STAND);
            as.setMarker(true);
            as.setInvisible(true);
            as.setSmall(false);
            as.setGravity(false);
            as.setCustomNameVisible(true);
            as.setCustomName(line);
            as.setMetadata("mrsc_hologram", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)key));
            list.add(as);
        }
        this.hologramsByKey.put(key, list);
    }

    public void remove(String key) {
        List<ArmorStand> list = this.hologramsByKey.remove(key);
        if (list != null) {
            for (ArmorStand as : list) {
                if (as == null || as.isDead()) continue;
                as.remove();
            }
        }
        this.lastContent.remove(key);
    }

    public void removeAll() {
        for (String key : new ArrayList<String>(this.hologramsByKey.keySet())) {
            this.remove(key);
        }
    }

    public boolean exists(String key) {
        return this.hologramsByKey.containsKey(key);
    }

    public void cleanup() {
        this.removeAll();
        this.lastContent.clear();
        for (World world : Bukkit.getWorlds()) {
            for (ArmorStand as : world.getEntitiesByClass(ArmorStand.class)) {
                if (!as.hasMetadata("mrsc_hologram")) continue;
                as.remove();
            }
        }
    }
}

