/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests;

import eu.mrneznamy.mrSellChests.Commands;
import eu.mrneznamy.mrSellChests.SellChestListener;
import eu.mrneznamy.mrSellChests.SellChestManager;
import eu.mrneznamy.mrSellChests.TabComplete;
import eu.mrneznamy.mrSellChests.database.SellChestsDatabaseManager;
import eu.mrneznamy.mrSellChests.hologram.SellChestHologramManager;
import eu.mrneznamy.mrSellChests.integration.MrSellChestsItemProviderWrapper;
import eu.mrneznamy.mrlibcore.MrLibRegisterPlugin;
import eu.mrneznamy.mrlibcore.economy.MrLibVaultManager;
import eu.mrneznamy.mrlibcore.messages.MrLibMessage;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrSellChests
extends JavaPlugin {
    private MrLibMessage messageSystem;
    private SellChestListener sellChestListener;
    private SellChestManager sellChestManager;
    private SellChestsDatabaseManager databaseManager;
    private String prefix;
    private YamlConfiguration boostersConfig;
    private MrSellChestsItemProviderWrapper itemProviderWrapper;
    private Object itemProvider;
    private File messagesFile;
    private FileConfiguration messagesConfig;

    public void onEnable() {
        if (this.getServer().getPluginManager().getPlugin("MrLibCore") == null) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("MrSellChests requires MrLibCore to run!");
            this.getLogger().severe("Please download MrLibCore from:");
            this.getLogger().severe("https://modrinth.com/plugin/mrlibcore");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.saveDefaultMessagesFile();
        this.databaseManager = new SellChestsDatabaseManager(this);
        this.messageSystem = new MrLibMessage((JavaPlugin)this);
        this.prefix = MrLibColors.colorize((String)this.messagesConfig.getString("MrSellChests.Prefix", "&8[&aMrSellChests&8]"));
        if (!this.setupEconomy()) {
            String vaultMessage = this.messagesConfig.getString("MrSellChests.vault_not_found", "&cDisabled due to no Vault dependency found!");
            this.getLogger().severe(MrLibColors.colorize((String)vaultMessage));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.sellChestManager = new SellChestManager(this);
        this.getCommand("msc").setExecutor((CommandExecutor)new Commands(this));
        this.getCommand("msc").setTabCompleter((TabCompleter)new TabComplete(this));
        this.sellChestListener = new SellChestListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.sellChestListener, (Plugin)this);
        this.sellChestListener.removeAllSellChestHolograms();
        this.sellChestListener.restoreAllSellChestHolograms();
        File boostersFile = new File(this.getDataFolder(), "boosters.yml");
        this.boostersConfig = YamlConfiguration.loadConfiguration((File)boostersFile);
        MrLibRegisterPlugin.register((JavaPlugin)this, (String)"mrsellchests");
        String hologramProvider = this.getConfig().getString("MrSellChests.Holograms.Provider", "DecentHolograms");
        MrLibConsoleSayer.MrSay_Success((String)("Hologram Provider: " + hologramProvider));
        this.registerHelpCommands();
        this.registerCustomItems();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        return MrLibVaultManager.getInstance().isEnabled();
    }

    public MrLibVaultManager getEconomy() {
        return MrLibVaultManager.getInstance();
    }

    public SellChestHologramManager getHologramManager() {
        if (this.sellChestListener != null) {
            return this.sellChestListener.getHologramManager();
        }
        return null;
    }

    public MrLibMessage getMessageSystem() {
        return this.messageSystem;
    }

    public void sendMessage(Player player, String message) {
        if (message == null || ((String)message).isEmpty()) {
            return;
        }
        if (((String)message).contains("(!NOPREFIX!)")) {
            message = ((String)message).replace("(!NOPREFIX!)", "");
            this.messageSystem.send(player, (String)message);
        } else {
            String prefix = this.getPrefix();
            message = ((String)message).contains("(!message!)") ? ((String)message).replace("(!message!)", "(!message!)" + prefix + " ") : prefix + " " + (String)message;
            this.messageSystem.send(player, (String)message);
        }
    }

    public String getPrefix() {
        String prefixFromConfig;
        if (this.messagesConfig != null && (prefixFromConfig = this.messagesConfig.getString("MrSellChests.Prefix")) != null) {
            return prefixFromConfig;
        }
        return this.prefix;
    }

    public String getMessage(String path) {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (messagesFile.exists()) {
            YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
            String message = messages.getString("MrSellChests." + path);
            if (message != null) {
                if (message.contains("(!message!)")) {
                    message = message.replace("(!message!)", "");
                }
                return MrLibColors.colorize((String)message);
            }
            message = messages.getString(path);
            if (message != null) {
                if (message.contains("(!message!)")) {
                    message = message.replace("(!message!)", "");
                }
                return MrLibColors.colorize((String)message);
            }
        }
        return this.prefix + " &cMessage not found: " + path;
    }

    public String getMessage(String path, String defaultValue) {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (messagesFile.exists()) {
            YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
            String message = messages.getString("MrSellChests." + path);
            if (message != null) {
                if (message.contains("(!message!)")) {
                    message = message.replace("(!message!)", "");
                }
                return MrLibColors.colorize((String)message);
            }
            message = messages.getString(path);
            if (message != null) {
                if (message.contains("(!message!)")) {
                    message = message.replace("(!message!)", "");
                }
                return MrLibColors.colorize((String)message);
            }
        }
        if (defaultValue.contains("(!message!)")) {
            defaultValue = defaultValue.replace("(!message!)", "");
        }
        return this.prefix + " " + MrLibColors.colorize((String)defaultValue);
    }

    private void saveDefaultMessagesFile() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public String getMessageFromConfig(String path) {
        if (this.messagesConfig != null) {
            String message = this.messagesConfig.getString("MrSellChests." + path);
            if (message == null) {
                message = this.messagesConfig.getString(path);
            }
            return message;
        }
        return null;
    }

    public FileConfiguration getMessages() {
        return this.getConfig();
    }

    private void registerHelpCommands() {
        ArrayList<MrLibHelper.CommandInfo> commands = new ArrayList<MrLibHelper.CommandInfo>();
        commands.add(new MrLibHelper.CommandInfo("/msc give <player> <chest> <amount>", "Give sell chest to player", "/msc give Player123 Basic 1"));
        commands.add(new MrLibHelper.CommandInfo("/msc boost <player> <boost> <duration>", "Give temporary boost to player", "/msc boost Player123 2.0 300"));
        commands.add(new MrLibHelper.CommandInfo("/msc reload", "Reload plugin configuration", "/msc reload"));
        MrLibHelper.registerPluginCommands((JavaPlugin)this, (String)"MrSellChests", commands);
    }

    public SellChestManager getSellChestManager() {
        return this.sellChestManager;
    }

    public void onDisable() {
        if (this.sellChestListener != null) {
            this.sellChestListener.removeAllSellChestHolograms();
        }
        if (this.sellChestManager != null) {
            this.sellChestManager.shutdown();
        }
        if (this.getHologramManager() != null) {
            this.getHologramManager().cleanup();
        }
        if (this.itemProvider != null && Bukkit.getPluginManager().getPlugin("MrUltimateShop") != null) {
            try {
                Class<?> apiClass = Class.forName("eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI");
                Method unregisterMethod = apiClass.getMethod("unregisterItemProvider", String.class);
                unregisterMethod.invoke(null, "MrSellChests");
                this.getLogger().info("Custom items unregistered from MrUltimateShop!");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to unregister custom items: " + e.getMessage());
            }
        }
    }

    private void registerCustomItems() {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            block5: {
                if (Bukkit.getPluginManager().getPlugin("MrUltimateShop") != null) {
                    try {
                        Class<?> apiClass = Class.forName("eu.mrneznamy.mrultimateshop.api.MrUltimateShopAPI");
                        Method registerMethod = apiClass.getMethod("registerItemProvider", Class.forName("eu.mrneznamy.mrultimateshop.api.CustomItemProvider"));
                        this.itemProviderWrapper = new MrSellChestsItemProviderWrapper(this);
                        this.itemProvider = this.itemProviderWrapper.createProvider();
                        if (this.itemProvider != null) {
                            registerMethod.invoke(null, this.itemProvider);
                            Method getAvailableItemsMethod = this.itemProvider.getClass().getMethod("getAvailableItems", new Class[0]);
                            String[] stringArray = (String[])getAvailableItemsMethod.invoke(this.itemProvider, new Object[0]);
                            break block5;
                        }
                        this.getLogger().warning("Failed to create item provider wrapper!");
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to register custom items with MrUltimateShop: " + e.getMessage());
                    }
                } else {
                    this.getLogger().info("MrUltimateShop not found! Custom items will not be available in shop.");
                }
            }
        }, 20L);
    }

    public YamlConfiguration getBoostersConfig() {
        return this.boostersConfig;
    }
}

