/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests.database;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibDatabaseManager;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class SellChestsDatabaseManager {
    private final MrSellChests plugin;
    private final String storageType;
    private final MrLibDatabase database;
    private final File dataFile;
    private final File boostersFile;
    private YamlConfiguration dataYaml;
    private YamlConfiguration boostersYaml;

    public SellChestsDatabaseManager(MrSellChests plugin) {
        this.plugin = plugin;
        this.storageType = plugin.getConfig().getString("Database.Type", "yml").toLowerCase();
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.boostersFile = new File(plugin.getDataFolder(), "boosters.yml");
        if ("mysql".equals(this.storageType) || "sqlite".equals(this.storageType)) {
            this.database = this.initializeDatabase();
            if (this.database != null) {
                this.createTables();
            } else {
                this.loadYAMLFiles();
            }
        } else {
            this.database = null;
            this.loadYAMLFiles();
        }
    }

    private void loadYAMLFiles() {
        this.dataYaml = !this.dataFile.exists() ? new YamlConfiguration() : YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.boostersYaml = !this.boostersFile.exists() ? new YamlConfiguration() : YamlConfiguration.loadConfiguration((File)this.boostersFile);
    }

    private MrLibDatabase initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        if ("mysql".equals(this.storageType)) {
            String host = config.getString("Database.MySQL.Host", "localhost");
            int port = config.getInt("Database.MySQL.Port", 3306);
            String dbName = config.getString("Database.MySQL.Database", "sellchests");
            String username = config.getString("Database.MySQL.Username", "root");
            String password = config.getString("Database.MySQL.Password", "");
            MrLibDatabase db = MrLibDatabaseManager.registerMySQL((String)this.plugin.getName(), (String)host, (int)port, (String)dbName, (String)username, (String)password);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrSellChests connected to MySQL database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to MySQL! Using YAML instead.");
            return null;
        }
        if ("sqlite".equals(this.storageType)) {
            String fileName = config.getString("Database.SQLite.FileName", "sellchests.db");
            MrLibDatabase db = MrLibDatabaseManager.registerSQLite((JavaPlugin)this.plugin, (String)fileName);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrSellChests connected to SQLite database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to SQLite! Using YAML instead.");
            return null;
        }
        return null;
    }

    private void createTables() {
        if (this.database == null) {
            return;
        }
        this.database.createTable("sell_chests", "chest_key VARCHAR(255) PRIMARY KEY, owner VARCHAR(100) NOT NULL, player_uuid VARCHAR(36), world VARCHAR(100) NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, type VARCHAR(50) NOT NULL, hologram_enabled BOOLEAN DEFAULT TRUE, chunk_collector_enabled BOOLEAN DEFAULT FALSE, trasher_mode VARCHAR(20) DEFAULT 'REMOVE', linked_chests TEXT");
        this.database.createTable("chest_statistics", "chest_key VARCHAR(255) PRIMARY KEY, items_sold INTEGER DEFAULT 0, deleted_items INTEGER DEFAULT 0, money_earned DOUBLE DEFAULT 0.0");
        this.database.createTable("boosters", "owner_uuid VARCHAR(36) NOT NULL, booster_id VARCHAR(100) NOT NULL, expiration_time BIGINT NOT NULL, PRIMARY KEY (owner_uuid, booster_id)");
        this.database.createTable("chest_inventory", "chest_key VARCHAR(255) NOT NULL, slot INTEGER NOT NULL, item_data TEXT, PRIMARY KEY (chest_key, slot)");
        MrLibConsoleSayer.MrSay_Success((String)"MrSellChests database tables created/verified!");
    }

    public boolean isUsingDatabase() {
        return this.database != null && this.database.isConnected();
    }

    public YamlConfiguration getDataYaml() {
        return this.dataYaml;
    }

    public YamlConfiguration getBoostersYaml() {
        return this.boostersYaml;
    }

    public void saveDataYaml() {
        if (this.database == null && this.dataYaml != null) {
            try {
                this.dataYaml.save(this.dataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveBoostersYaml() {
        if (this.database == null && this.boostersYaml != null) {
            try {
                this.boostersYaml.save(this.boostersFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.database != null) {
            MrLibDatabaseManager.unregister((String)this.plugin.getName());
        }
        this.saveDataYaml();
        this.saveBoostersYaml();
    }
}

