/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrSellChests.database;

import eu.mrneznamy.mrSellChests.MrSellChests;
import eu.mrneznamy.mrlibcore.database.MrLibDatabase;
import eu.mrneznamy.mrlibcore.database.MrLibDatabaseManager;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class SellChestsDatabaseManager {
    private final MrSellChests plugin;
    private final String storageType;
    private final MrLibDatabase database;
    private final File dataFile;
    private final File boostersFile;
    private YamlConfiguration dataYaml;
    private YamlConfiguration boostersYaml;

    public SellChestsDatabaseManager(MrSellChests plugin) {
        this.plugin = plugin;
        this.storageType = plugin.getConfig().getString("Database.Type", "yml").toLowerCase();
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.boostersFile = new File(plugin.getDataFolder(), "boosters.yml");
        if ("mysql".equals(this.storageType) || "sqlite".equals(this.storageType)) {
            this.database = this.initializeDatabase();
            if (this.database != null) {
                this.createTables();
            } else {
                this.loadYAMLFiles();
            }
        } else {
            this.database = null;
            this.loadYAMLFiles();
        }
    }

    private void loadYAMLFiles() {
        this.dataYaml = !this.dataFile.exists() ? new YamlConfiguration() : YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.boostersYaml = !this.boostersFile.exists() ? new YamlConfiguration() : YamlConfiguration.loadConfiguration((File)this.boostersFile);
    }

    private MrLibDatabase initializeDatabase() {
        FileConfiguration config = this.plugin.getConfig();
        if ("mysql".equals(this.storageType)) {
            String host = config.getString("Database.MySQL.Host", "localhost");
            int port = config.getInt("Database.MySQL.Port", 3306);
            String dbName = config.getString("Database.MySQL.Database", "sellchests");
            String username = config.getString("Database.MySQL.Username", "root");
            String password = config.getString("Database.MySQL.Password", "");
            MrLibDatabase db = MrLibDatabaseManager.registerMySQL((String)this.plugin.getName(), (String)host, (int)port, (String)dbName, (String)username, (String)password);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrSellChests connected to MySQL database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to MySQL! Using YAML instead.");
            return null;
        }
        if ("sqlite".equals(this.storageType)) {
            String fileName = config.getString("Database.SQLite.FileName", "sellchests.db");
            MrLibDatabase db = MrLibDatabaseManager.registerSQLite((JavaPlugin)this.plugin, (String)fileName);
            if (db != null) {
                MrLibConsoleSayer.MrSay_Success((String)"MrSellChests connected to SQLite database!");
                return db;
            }
            MrLibConsoleSayer.MrSay_Error((String)"Failed to connect to SQLite! Using YAML instead.");
            return null;
        }
        return null;
    }

    private void createTables() {
        if (this.database == null) {
            return;
        }
        this.database.createTable("sell_chests", "chest_key VARCHAR(255) PRIMARY KEY, owner VARCHAR(100) NOT NULL, player_uuid VARCHAR(36), world VARCHAR(100) NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, type VARCHAR(50) NOT NULL, hologram_enabled BOOLEAN DEFAULT TRUE, chunk_collector_enabled BOOLEAN DEFAULT FALSE, trasher_mode VARCHAR(20) DEFAULT 'REMOVE', linked_chests TEXT");
        this.database.createTable("chest_statistics", "chest_key VARCHAR(255) PRIMARY KEY, items_sold INTEGER DEFAULT 0, deleted_items INTEGER DEFAULT 0, money_earned DOUBLE DEFAULT 0.0");
        this.database.createTable("boosters", "owner_uuid VARCHAR(36) NOT NULL, booster_id VARCHAR(100) NOT NULL, expiration_time BIGINT NOT NULL, PRIMARY KEY (owner_uuid, booster_id)");
        this.database.createTable("chest_inventory", "chest_key VARCHAR(255) NOT NULL, slot INTEGER NOT NULL, item_data TEXT, PRIMARY KEY (chest_key, slot)");
        MrLibConsoleSayer.MrSay_Success((String)"MrSellChests database tables created/verified!");
    }

    public boolean isUsingDatabase() {
        return this.database != null && this.database.isConnected();
    }

    public YamlConfiguration getDataYaml() {
        return this.dataYaml;
    }

    public YamlConfiguration getBoostersYaml() {
        return this.boostersYaml;
    }

    public void saveDataYaml() {
        if (this.database == null && this.dataYaml != null) {
            try {
                this.dataYaml.save(this.dataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveBoostersYaml() {
        if (this.database == null && this.boostersYaml != null) {
            try {
                this.boostersYaml.save(this.boostersFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.database != null) {
            MrLibDatabaseManager.unregister((String)this.plugin.getName());
        }
        this.saveDataYaml();
        this.saveBoostersYaml();
    }

    public Set<String> getAllChestKeys() {
        if (this.isUsingDatabase()) {
            HashSet<String> result = new HashSet<String>();
            this.database.executeQuery("SELECT chest_key FROM sell_chests", resultSet -> {
                try {
                    while (resultSet.next()) {
                        result.add(resultSet.getString("chest_key"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[0]);
            return result;
        }
        return this.dataYaml.getKeys(false);
    }

    public String getChestType(String chestKey) {
        if (this.isUsingDatabase()) {
            String[] result = new String[]{null};
            this.database.executeQuery("SELECT type FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        result[0] = resultSet.getString("type");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return result[0];
        }
        return this.dataYaml.getString(chestKey + ".type");
    }

    public boolean getChestCollectorEnabled(String chestKey) {
        if (this.isUsingDatabase()) {
            boolean[] result = new boolean[]{false};
            this.plugin.getLogger().info("[DEBUG] getChestCollectorEnabled - querying database for chestKey: " + chestKey);
            this.database.executeQuery("SELECT chunk_collector_enabled FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        result[0] = resultSet.getBoolean("chunk_collector_enabled");
                        this.plugin.getLogger().info("[DEBUG] getChestCollectorEnabled - found result: " + result[0]);
                    } else {
                        this.plugin.getLogger().info("[DEBUG] getChestCollectorEnabled - no result found for chestKey: " + chestKey);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("[DEBUG] getChestCollectorEnabled - error: " + e.getMessage());
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            this.plugin.getLogger().info("[DEBUG] getChestCollectorEnabled - returning: " + result[0]);
            return result[0];
        }
        boolean result = this.dataYaml.getBoolean(chestKey + ".chunk_collector_enabled", false);
        this.plugin.getLogger().info("[DEBUG] getChestCollectorEnabled - YAML result: " + result + " for chestKey: " + chestKey);
        return result;
    }

    public void setChestCollectorEnabled(String chestKey, boolean enabled) {
        this.plugin.getLogger().info("[DEBUG] setChestCollectorEnabled - setting " + chestKey + " to " + enabled);
        if (this.isUsingDatabase()) {
            this.plugin.getLogger().info("[DEBUG] setChestCollectorEnabled - updating database");
            this.database.executeUpdate("UPDATE sell_chests SET chunk_collector_enabled = ? WHERE chest_key = ?", new Object[]{enabled, chestKey});
            this.plugin.getLogger().info("[DEBUG] setChestCollectorEnabled - database update completed");
        } else {
            this.plugin.getLogger().info("[DEBUG] setChestCollectorEnabled - updating YAML");
            this.dataYaml.set(chestKey + ".chunk_collector_enabled", (Object)enabled);
            this.saveDataYaml();
            this.plugin.getLogger().info("[DEBUG] setChestCollectorEnabled - YAML update completed");
        }
    }

    public boolean chestExists(String chestKey) {
        if (this.isUsingDatabase()) {
            int[] count = new int[]{0};
            this.database.executeQuery("SELECT COUNT(*) FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        count[0] = resultSet.getInt(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return count[0] > 0;
        }
        return this.dataYaml.contains(chestKey);
    }

    public void createChest(String chestKey, String owner, String playerUuid, String world, int x, int y, int z, String type) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO sell_chests (chest_key, owner, player_uuid, world, x, y, z, type) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{chestKey, owner, playerUuid, world, x, y, z, type});
        } else {
            this.dataYaml.set(chestKey + ".owner", (Object)owner);
            this.dataYaml.set(chestKey + ".player_uuid", (Object)playerUuid);
            this.dataYaml.set(chestKey + ".world", (Object)world);
            this.dataYaml.set(chestKey + ".x", (Object)x);
            this.dataYaml.set(chestKey + ".y", (Object)y);
            this.dataYaml.set(chestKey + ".z", (Object)z);
            this.dataYaml.set(chestKey + ".type", (Object)type);
            this.saveDataYaml();
        }
    }

    public void deleteChest(String chestKey) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("DELETE FROM sell_chests WHERE chest_key = ?", new Object[]{chestKey});
            this.database.executeUpdate("DELETE FROM chest_statistics WHERE chest_key = ?", new Object[]{chestKey});
            this.database.executeUpdate("DELETE FROM chest_inventory WHERE chest_key = ?", new Object[]{chestKey});
        } else {
            this.dataYaml.set(chestKey, null);
            this.saveDataYaml();
        }
    }

    public String getChestOwner(String chestKey) {
        if (this.isUsingDatabase()) {
            String[] result = new String[]{null};
            this.database.executeQuery("SELECT owner FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        result[0] = resultSet.getString("owner");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return result[0];
        }
        return this.dataYaml.getString(chestKey + ".owner");
    }

    public String getChestPlayerUuid(String chestKey) {
        if (this.isUsingDatabase()) {
            String[] result = new String[]{null};
            this.database.executeQuery("SELECT player_uuid FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        result[0] = resultSet.getString("player_uuid");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return result[0];
        }
        return this.dataYaml.getString(chestKey + ".player_uuid");
    }

    public boolean getChestHologramEnabled(String chestKey) {
        if (this.isUsingDatabase()) {
            boolean[] result = new boolean[]{true};
            this.database.executeQuery("SELECT hologram_enabled FROM sell_chests WHERE chest_key = ?", resultSet -> {
                try {
                    if (resultSet.next()) {
                        result[0] = resultSet.getBoolean("hologram_enabled");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return result[0];
        }
        return this.dataYaml.getBoolean(chestKey + ".hologram_enabled", true);
    }

    public void setChestHologramEnabled(String chestKey, boolean enabled) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("UPDATE sell_chests SET hologram_enabled = ? WHERE chest_key = ?", new Object[]{enabled, chestKey});
        } else {
            this.dataYaml.set(chestKey + ".hologram_enabled", (Object)enabled);
            this.saveDataYaml();
        }
    }

    public String getChestTrasherMode(String chestKey) {
        if (this.isUsingDatabase()) {
            String[] mode = new String[]{"REMOVE"};
            this.database.executeQuery("SELECT trasher_mode FROM sell_chests WHERE chest_key = ?", rs -> {
                try {
                    String result;
                    if (rs.next() && (result = rs.getString("trasher_mode")) != null) {
                        mode[0] = result;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return mode[0];
        }
        return this.dataYaml.getString(chestKey + ".trasher_mode", "REMOVE");
    }

    public void setChestTrasherMode(String chestKey, String mode) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("UPDATE sell_chests SET trasher_mode = ? WHERE chest_key = ?", new Object[]{mode, chestKey});
        } else {
            this.dataYaml.set(chestKey + ".trasher_mode", (Object)mode);
            this.saveDataYaml();
        }
    }

    public int getItemsSold(String chestKey) {
        if (this.isUsingDatabase()) {
            int[] count = new int[]{0};
            this.database.executeQuery("SELECT items_sold FROM chest_statistics WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        count[0] = rs.getInt("items_sold");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return count[0];
        }
        return this.dataYaml.getInt(chestKey + ".items_sold", 0);
    }

    public void setItemsSold(String chestKey, int count) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO chest_statistics (chest_key, items_sold) VALUES (?, ?) ON DUPLICATE KEY UPDATE items_sold = ?", new Object[]{chestKey, count, count});
        } else {
            this.dataYaml.set(chestKey + ".items_sold", (Object)count);
            this.saveDataYaml();
        }
    }

    public int getDeletedItems(String chestKey) {
        if (this.isUsingDatabase()) {
            int[] count = new int[]{0};
            this.database.executeQuery("SELECT deleted_items FROM chest_statistics WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        count[0] = rs.getInt("deleted_items");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return count[0];
        }
        return this.dataYaml.getInt(chestKey + ".deleted_items", 0);
    }

    public void setDeletedItems(String chestKey, int count) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO chest_statistics (chest_key, deleted_items) VALUES (?, ?) ON DUPLICATE KEY UPDATE deleted_items = ?", new Object[]{chestKey, count, count});
        } else {
            this.dataYaml.set(chestKey + ".deleted_items", (Object)count);
            this.saveDataYaml();
        }
    }

    public double getMoneyEarned(String chestKey) {
        if (this.isUsingDatabase()) {
            double[] amount = new double[]{0.0};
            this.database.executeQuery("SELECT money_earned FROM chest_statistics WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        amount[0] = rs.getDouble("money_earned");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return amount[0];
        }
        return this.dataYaml.getDouble(chestKey + ".money_earned", 0.0);
    }

    public void setMoneyEarned(String chestKey, double amount) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO chest_statistics (chest_key, money_earned) VALUES (?, ?) ON DUPLICATE KEY UPDATE money_earned = ?", new Object[]{chestKey, amount, amount});
        } else {
            this.dataYaml.set(chestKey + ".money_earned", (Object)amount);
            this.saveDataYaml();
        }
    }

    public ItemStack getInventoryItem(String chestKey, int slot) {
        if (this.isUsingDatabase()) {
            String[] itemData = new String[]{null};
            this.database.executeQuery("SELECT item_data FROM chest_inventory WHERE chest_key = ? AND slot = ?", rs -> {
                try {
                    if (rs.next()) {
                        itemData[0] = rs.getString("item_data");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey, slot});
            if (itemData[0] != null && !itemData[0].isEmpty()) {
                return null;
            }
            return null;
        }
        return this.dataYaml.getItemStack(chestKey + ".inventory." + slot);
    }

    public void setInventoryItem(String chestKey, int slot, ItemStack item) {
        if (this.isUsingDatabase()) {
            if (item != null) {
                String itemData = "";
                this.database.executeUpdate("INSERT INTO chest_inventory (chest_key, slot, item_data) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE item_data = ?", new Object[]{chestKey, slot, itemData, itemData});
            } else {
                this.database.executeUpdate("DELETE FROM chest_inventory WHERE chest_key = ? AND slot = ?", new Object[]{chestKey, slot});
            }
        } else {
            if (item != null) {
                this.dataYaml.set(chestKey + ".inventory." + slot, (Object)item);
            } else {
                this.dataYaml.set(chestKey + ".inventory." + slot, null);
            }
            this.saveDataYaml();
        }
    }

    public boolean hasInventoryData(String chestKey) {
        if (this.isUsingDatabase()) {
            boolean[] hasData = new boolean[]{false};
            this.database.executeQuery("SELECT COUNT(*) as count FROM chest_inventory WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        hasData[0] = rs.getInt("count") > 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return hasData[0];
        }
        return this.dataYaml.contains(chestKey + ".inventory");
    }

    public void clearInventory(String chestKey) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("DELETE FROM chest_inventory WHERE chest_key = ?", new Object[]{chestKey});
        } else {
            this.dataYaml.set(chestKey + ".inventory", null);
            this.saveDataYaml();
        }
    }

    public boolean hasBooster(String playerUuid, String boosterId) {
        if (this.isUsingDatabase()) {
            boolean[] hasBooster = new boolean[]{false};
            this.database.executeQuery("SELECT COUNT(*) as count FROM boosters WHERE owner_uuid = ? AND booster_id = ? AND expiration_time > ?", rs -> {
                try {
                    if (rs.next()) {
                        hasBooster[0] = rs.getInt("count") > 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{playerUuid, boosterId, System.currentTimeMillis()});
            return hasBooster[0];
        }
        ConfigurationSection boosters = this.boostersYaml.getConfigurationSection("Boosters");
        if (boosters != null) {
            for (String key : boosters.getKeys(false)) {
                ConfigurationSection booster = boosters.getConfigurationSection(key);
                if (booster == null || !playerUuid.equals(booster.getString("owner_uuid")) || !boosterId.equals(booster.getString("booster_id")) || booster.getLong("expiration_time") <= System.currentTimeMillis()) continue;
                return true;
            }
        }
        return false;
    }

    public void addBooster(String playerUuid, String boosterId, long expirationTime) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO boosters (owner_uuid, booster_id, expiration_time) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE expiration_time = ?", new Object[]{playerUuid, boosterId, expirationTime, expirationTime});
        } else {
            String key = "Boosters." + UUID.randomUUID().toString();
            this.boostersYaml.set(key + ".owner_uuid", (Object)playerUuid);
            this.boostersYaml.set(key + ".booster_id", (Object)boosterId);
            this.boostersYaml.set(key + ".expiration_time", (Object)expirationTime);
            this.saveBoostersYaml();
        }
    }

    public void removeExpiredBoosters() {
        long currentTime = System.currentTimeMillis();
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("DELETE FROM boosters WHERE expiration_time <= ?", new Object[]{currentTime});
        } else {
            ConfigurationSection boosters = this.boostersYaml.getConfigurationSection("Boosters");
            if (boosters != null) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String key : boosters.getKeys(false)) {
                    ConfigurationSection booster = boosters.getConfigurationSection(key);
                    if (booster == null || booster.getLong("expiration_time") > currentTime) continue;
                    toRemove.add(key);
                }
                for (String key : toRemove) {
                    this.boostersYaml.set("Boosters." + key, null);
                }
                if (!toRemove.isEmpty()) {
                    this.saveBoostersYaml();
                }
            }
        }
    }

    public boolean isCollectorEnabled(String chestKey) {
        if (this.isUsingDatabase()) {
            boolean[] enabled = new boolean[]{false};
            this.database.executeQuery("SELECT chunk_collector_enabled FROM sell_chests WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        enabled[0] = rs.getBoolean("chunk_collector_enabled");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return enabled[0];
        }
        return this.dataYaml.getBoolean(chestKey + ".chunk_collector_enabled", false);
    }

    public void setCollectorTaskId(String chestKey, int taskId) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("UPDATE sell_chests SET collector_task_id = ? WHERE chest_key = ?", new Object[]{taskId, chestKey});
        } else {
            this.dataYaml.set(chestKey + ".collector_task_id", (Object)taskId);
            this.saveDataYaml();
        }
    }

    public int getPendingDeletedItems(String chestKey) {
        if (this.isUsingDatabase()) {
            int[] count = new int[]{0};
            this.database.executeQuery("SELECT pending_deleted_items FROM chest_statistics WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        count[0] = rs.getInt("pending_deleted_items");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return count[0];
        }
        return this.dataYaml.getInt(chestKey + ".statistics.pending_deleted_items", 0);
    }

    public void setPendingDeletedItems(String chestKey, int count) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO chest_statistics (chest_key, pending_deleted_items) VALUES (?, ?) ON DUPLICATE KEY UPDATE pending_deleted_items = ?", new Object[]{chestKey, count, count});
        } else {
            this.dataYaml.set(chestKey + ".statistics.pending_deleted_items", (Object)count);
            this.saveDataYaml();
        }
    }

    public List<String> getLinkedChests(String chestKey) {
        if (this.isUsingDatabase()) {
            return new ArrayList<String>();
        }
        List rawList = this.dataYaml.getList(chestKey + ".linked_chests", new ArrayList());
        ArrayList<String> linkedChests = new ArrayList<String>();
        for (Object obj : rawList) {
            linkedChests.add(String.valueOf(obj));
        }
        return linkedChests;
    }

    public void setLinkedChests(String chestKey, List<String> linkedChests) {
        if (!this.isUsingDatabase()) {
            this.dataYaml.set(chestKey + ".linked_chests", linkedChests);
            this.saveDataYaml();
        }
    }

    public boolean getChestLinking(String chestKey) {
        if (this.isUsingDatabase()) {
            boolean[] linking = new boolean[]{false};
            this.database.executeQuery("SELECT linking FROM sell_chests WHERE chest_key = ?", rs -> {
                try {
                    if (rs.next()) {
                        linking[0] = rs.getBoolean("linking");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new Object[]{chestKey});
            return linking[0];
        }
        return this.dataYaml.getBoolean(chestKey + ".linking", false);
    }

    public void setChestLinking(String chestKey, boolean linking) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("UPDATE sell_chests SET linking = ? WHERE chest_key = ?", new Object[]{linking, chestKey});
        } else {
            this.dataYaml.set(chestKey + ".linking", (Object)linking);
            this.saveDataYaml();
        }
    }

    public int countPlayerChests(UUID playerUUID) {
        if (this.database == null) {
            return 0;
        }
        int[] count = new int[]{0};
        this.database.executeQuery("SELECT COUNT(*) as count FROM sell_chests WHERE owner_uuid = ?", rs -> {
            try {
                if (rs.next()) {
                    count[0] = rs.getInt("count");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{playerUUID.toString()});
        return count[0];
    }

    public boolean isChestInSameChunk(String world, int chunkX, int chunkZ) {
        if (this.database == null) {
            return false;
        }
        boolean[] exists = new boolean[]{false};
        this.database.executeQuery("SELECT COUNT(*) as count FROM sell_chests WHERE world = ? AND chunk_x = ? AND chunk_z = ?", rs -> {
            try {
                if (rs.next()) {
                    exists[0] = rs.getInt("count") > 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{world, chunkX, chunkZ});
        return exists[0];
    }

    public double getPlayerBoostValue(UUID playerUUID) {
        if (this.database == null) {
            return 0.0;
        }
        double[] boost = new double[]{0.0};
        this.database.executeQuery("SELECT boost_value FROM player_boosters WHERE player_uuid = ? AND boost_until > ?", rs -> {
            try {
                if (rs.next()) {
                    boost[0] = rs.getDouble("boost_value");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{playerUUID.toString(), System.currentTimeMillis()});
        return boost[0];
    }

    public long getPlayerBoostUntil(UUID playerUUID) {
        if (this.database == null) {
            return 0L;
        }
        long[] until = new long[]{0L};
        this.database.executeQuery("SELECT boost_until FROM player_boosters WHERE player_uuid = ? AND boost_until > ?", rs -> {
            try {
                if (rs.next()) {
                    until[0] = rs.getLong("boost_until");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, new Object[]{playerUUID.toString(), System.currentTimeMillis()});
        return until[0];
    }

    public void setPlayerBoost(String playerUuid, double value, long until) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("INSERT INTO player_boosts (player_uuid, boost_value, boost_until) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE boost_value = ?, boost_until = ?", new Object[]{playerUuid, value, until, value, until});
        } else {
            this.dataYaml.set("players." + playerUuid + ".boost_temp.value", (Object)value);
            this.dataYaml.set("players." + playerUuid + ".boost_temp.until", (Object)until);
            this.saveDataYaml();
        }
    }

    public void removePlayerBoost(String playerUuid) {
        if (this.isUsingDatabase()) {
            this.database.executeUpdate("DELETE FROM player_boosts WHERE player_uuid = ?", new Object[]{playerUuid});
        } else {
            this.dataYaml.set("players." + playerUuid + ".boost_temp.value", null);
            this.dataYaml.set("players." + playerUuid + ".boost_temp.until", null);
            this.saveDataYaml();
        }
    }

    public boolean hasBoosterConfig(String boosterId) {
        if (this.isUsingDatabase()) {
            return this.boostersYaml.isConfigurationSection("Boosters." + boosterId);
        }
        return this.boostersYaml.isConfigurationSection("Boosters." + boosterId);
    }

    public double getBoosterBoost(String boosterId) {
        if (this.isUsingDatabase()) {
            return this.boostersYaml.getDouble("Boosters." + boosterId + ".Head.Boost", 1.0);
        }
        return this.boostersYaml.getDouble("Boosters." + boosterId + ".Head.Boost", 1.0);
    }

    public long getBoosterDuration(String boosterId) {
        if (this.isUsingDatabase()) {
            return this.boostersYaml.getLong("Boosters." + boosterId + ".Head.Duration", 60L);
        }
        return this.boostersYaml.getLong("Boosters." + boosterId + ".Head.Duration", 60L);
    }
}

