/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.RTPPlugin;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigGUI {
    private final RTPPlugin plugin;

    public ConfigGUI(RTPPlugin plugin) {
        this.plugin = plugin;
    }

    public void openConfigGUI(Player player) {
        ChestGui gui = new ChestGui(3, "RTP Configuration");
        StaticPane pane = new StaticPane(9, 3);
        pane.addItem(this.createGuiItem(Material.GOLD_INGOT, "Set Price", "Current: " + this.plugin.getCost()), 2, 1);
        pane.addItem(this.createGuiItem(Material.COMPASS, "Set Min Radius", "Current: " + this.plugin.getMinRadius()), 4, 1);
        pane.addItem(this.createGuiItem(Material.MAP, "Set Max Radius", "Current: " + this.plugin.getMaxRadius()), 6, 1);
        gui.addPane(pane);
        gui.show((HumanEntity)player);
    }

    private GuiItem createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.GOLD + name);
        meta.setLore(Arrays.asList(lore));
        item.setItemMeta(meta);
        return new GuiItem(item, event -> {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            String configKey = "";
            switch (name) {
                case "Set Price": {
                    configKey = "rtp.cost";
                    break;
                }
                case "Set Min Radius": {
                    configKey = "rtp.min-radius";
                    break;
                }
                case "Set Max Radius": {
                    configKey = "rtp.max-radius";
                }
            }
            player.closeInventory();
            player.sendMessage(ChatColor.YELLOW + "Please enter the new value for " + name + " in the chat:");
            this.plugin.awaitingConfigInput.put(player.getUniqueId(), configKey);
        });
    }
}

