/*
 * Decompiled with CFR 0.152.
 */
package com.funkel.rtpplugin;

import com.funkel.rtpplugin.ConfigGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RTPPlugin
extends JavaPlugin
implements Listener {
    private int minRadius;
    private int maxRadius;
    private double cost;
    private String teleportMessage;
    private String onlyPlayersMessage;
    private String notEnoughMoneyMessage;
    private String moneyDeductedMessage;
    private Economy economy;
    private boolean economyEnabled = false;
    private int maxAttempts;
    private String noSafeLocationMessage;
    private long searchTimeout;
    private List<Biome> unsafeBiomes;
    public HashMap<UUID, String> awaitingConfigInput = new HashMap();
    private ConfigGUI configGUI;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getScheduler().runTaskLater((Plugin)this, this::setupEconomy, 20L);
        this.configGUI = new ConfigGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("RTP Plugin v1.7-SNAPSHOT has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("RTP Plugin v1.3-SNAPSHOT has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.minRadius = config.getInt("rtp.min-radius", 1000);
        this.maxRadius = config.getInt("rtp.max-radius", 5000);
        this.cost = config.getDouble("rtp.cost", 0.0);
        this.teleportMessage = config.getString("rtp.messages.teleported", "You have been teleported to a random location!");
        this.onlyPlayersMessage = config.getString("rtp.messages.only-players", "This command can only be executed by players!");
        this.notEnoughMoneyMessage = config.getString("rtp.messages.not-enough-money", "You don't have enough money for the RTP command. Required: %cost%");
        this.moneyDeductedMessage = config.getString("rtp.messages.money-deducted", "%cost% has been deducted from your account.");
        this.maxAttempts = config.getInt("rtp.max-attempts", 50);
        this.noSafeLocationMessage = config.getString("rtp.messages.no-safe-location", "Could not find a safe location. Teleporting to spawn.");
        this.searchTimeout = config.getLong("rtp.search-timeout", 5000L);
        this.unsafeBiomes = Arrays.asList(Biome.OCEAN, Biome.DEEP_OCEAN, Biome.FROZEN_OCEAN);
        this.saveConfig();
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found. Economy features will be disabled.");
            this.economyEnabled = false;
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("No economy provider found. Economy features will be disabled.");
            this.economyEnabled = false;
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.economyEnabled = true;
        this.getLogger().info("Vault found and economy initialized successfully. Economy features are enabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("rtp")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.onlyPlayersMessage);
                return true;
            }
            final Player player = (Player)sender;
            if (this.economyEnabled && this.cost > 0.0) {
                if (!this.economy.has((OfflinePlayer)player, this.cost)) {
                    player.sendMessage(this.notEnoughMoneyMessage.replace("%cost%", String.format("%.2f", this.cost)));
                    return true;
                }
                this.economy.withdrawPlayer((OfflinePlayer)player, this.cost);
                player.sendMessage(this.moneyDeductedMessage.replace("%cost%", String.format("%.2f", this.cost)));
            }
            new BukkitRunnable(this){
                final /* synthetic */ RTPPlugin this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    World world = player.getWorld();
                    final Location spawnLocation = world.getSpawnLocation();
                    final Location randomLocation = this.this$0.getRandomLocation(spawnLocation, this.this$0.minRadius, this.this$0.maxRadius);
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (randomLocation.equals((Object)spawnLocation)) {
                                this.this$1.player.sendMessage(this.this$1.this$0.noSafeLocationMessage);
                            } else {
                                this.this$1.player.sendMessage(this.this$1.this$0.teleportMessage);
                            }
                            this.this$1.player.teleport(randomLocation);
                        }
                    }.runTask((Plugin)this.this$0);
                }
            }.runTaskAsynchronously((Plugin)this);
            return true;
        }
        if (command.getName().equalsIgnoreCase("rtpconfig")) {
            if (sender instanceof Player && sender.hasPermission("rtp.config")) {
                this.configGUI.openConfigGUI((Player)sender);
                return true;
            }
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.awaitingConfigInput.containsKey(playerUUID)) {
            event.setCancelled(true);
            String configKey = this.awaitingConfigInput.get(playerUUID);
            String input = event.getMessage();
            try {
                if (configKey.equals("rtp.cost")) {
                    double newCost = Double.parseDouble(input);
                    this.getConfig().set(configKey, (Object)newCost);
                    this.cost = newCost;
                } else {
                    int newValue = Integer.parseInt(input);
                    this.getConfig().set(configKey, (Object)newValue);
                    if (configKey.equals("rtp.min-radius")) {
                        this.minRadius = newValue;
                    } else if (configKey.equals("rtp.max-radius")) {
                        this.maxRadius = newValue;
                    }
                }
                this.saveConfig();
                player.sendMessage(ChatColor.GREEN + "Configuration updated successfully!");
            }
            catch (NumberFormatException e) {
                player.sendMessage(ChatColor.RED + "Invalid input. Please enter a number.");
            }
            this.awaitingConfigInput.remove(playerUUID);
        }
    }

    private Location getRandomLocation(Location center, int minRadius, int maxRadius) {
        Random random = new Random();
        World world = center.getWorld();
        long startTime = System.currentTimeMillis();
        for (int attempts = 0; attempts < this.maxAttempts; ++attempts) {
            int z;
            int y;
            if (System.currentTimeMillis() - startTime > this.searchTimeout) {
                this.getLogger().warning("RTP search timed out after " + this.searchTimeout + "ms.");
                return center;
            }
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int radius = random.nextInt(maxRadius - minRadius) + minRadius;
            int x = (int)(center.getX() + (double)radius * Math.cos(angle));
            Location location = new Location(world, (double)x, (double)((y = world.getHighestBlockYAt(x, z = (int)(center.getZ() + (double)radius * Math.sin(angle)))) + 1), (double)z);
            if (this.isSafeLocation(location)) {
                return location;
            }
            this.getLogger().info("Unsafe location found at " + location + ". Reason: " + this.getUnsafeReason(location));
        }
        this.getLogger().warning("Could not find a safe location after " + this.maxAttempts + " attempts.");
        return center;
    }

    private boolean isSafeLocation(Location location) {
        Block feet = location.getBlock();
        Block ground = feet.getRelative(0, -1, 0);
        return !feet.isLiquid() && !ground.isLiquid();
    }

    private String getUnsafeReason(Location location) {
        Block feet = location.getBlock();
        Block ground = feet.getRelative(0, -1, 0);
        if (feet.isLiquid()) {
            return "Feet in liquid";
        }
        if (ground.isLiquid()) {
            return "Ground is liquid";
        }
        return "Unknown reason";
    }

    public double getCost() {
        return this.cost;
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }
}

