/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)serverPlayer, (InventoryCloseEvent.Reason)InventoryCloseEvent.Reason.OPEN_NEW);
        serverPlayer.bV = serverPlayer.bU;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(serverPlayer, message);
        Inventory inventory = containerAnvil.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerAnvil.getContainerId();
        serverPlayer.b.sendPacket((Packet)new PacketPlayOutOpenWindow(containerId, Containers.h, message));
        serverPlayer.bV = containerAnvil;
        serverPlayer.initMenu((Container)containerAnvil);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(containerId, nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        PacketPlayOutSetSlot packet = new PacketPlayOutSetSlot(-1, -1, net.minecraft.world.item.ItemStack.b);
        this.getPlayerConnection(this.getServerPlayer(player)).sendPacket((Packet)packet);
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        this.getPlayerConnection(this.getServerPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        this.getPlayerConnection(serverPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(containerId, 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        private static final int RESULT_SLOT_INDEX = 2;
        @NotNull
        private final Field synchronizerField;

        public ContainerAnvilImpl(@NotNull EntityPlayer serverPlayer, IChatBaseComponent title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.getInventory(), ContainerAccess.at((World)serverPlayer.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.checkReachable = false;
            this.w.set((int)AnvilInventoryImpl.this.cost);
            this.setTitle(title);
            final Slot originalSlot = (Slot)this.i.get(2);
            Slot newSlot = new Slot(originalSlot.c, originalSlot.d, originalSlot.e, originalSlot.f){

                public boolean isAllowed(@NotNull net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public boolean isAllowed(@NotNull EntityHuman playerEntity) {
                    return true;
                }

                public void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
                    originalSlot.a(player, stack);
                }
            };
            this.i.set(2, (Object)newSlot);
            try {
                this.synchronizerField = Container.class.getDeclaredField("v");
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException("Unable to access field", exception);
            }
        }

        public void a(@Nullable String name) {
            ContainerSynchronizer synchronizer;
            AnvilInventoryImpl.this.text = name == null ? "" : name;
            try {
                this.synchronizerField.setAccessible(true);
                synchronizer = (ContainerSynchronizer)this.synchronizerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Unable to access field", exception);
            }
            synchronizer.sendSlotChange((Container)this, 2, this.getSlot(2).getItem());
        }

        public void i() {
        }

        public void b(@NotNull EntityHuman nmsPlayer) {
        }

        protected void a(@NotNull EntityHuman player, @NotNull IInventory inventory) {
        }

        protected void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

